/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.network.model.Headers;
import org.openqa.selenium.devtools.network.model.ResourcePriority;
import org.openqa.selenium.devtools.security.model.MixedContentType;
import org.openqa.selenium.json.JsonInput;

public class Request {
    private final String url;
    private final String urlFragment;
    private final String method;
    private final Headers headers;
    private final String postData;
    private final Boolean hasPostData;
    private final MixedContentType mixedContentType;
    private final ResourcePriority initialPriority;
    private final ReferrerPolicy referrerPolicy;
    private final Boolean isLinkPreload;

    public Request(String url, String urlFragment, String method, Headers headers, String postData, Boolean hasPostData, MixedContentType mixedContentType, ResourcePriority initialPriority, ReferrerPolicy referrerPolicy, Boolean isLinkPreload) {
        this.url = Objects.requireNonNull(url, "url is required");
        this.urlFragment = urlFragment;
        this.method = Objects.requireNonNull(method, "method is required");
        this.headers = Objects.requireNonNull(headers, "headers is required");
        this.postData = postData;
        this.hasPostData = hasPostData;
        this.mixedContentType = mixedContentType;
        this.initialPriority = Objects.requireNonNull(initialPriority, "initialPriority is required");
        this.referrerPolicy = Objects.requireNonNull(referrerPolicy, "referrerPolicy is required");
        this.isLinkPreload = isLinkPreload;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlFragment() {
        return this.urlFragment;
    }

    public String getMethod() {
        return this.method;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getPostData() {
        return this.postData;
    }

    public Boolean getHasPostData() {
        return this.hasPostData;
    }

    public MixedContentType getMixedContentType() {
        return this.mixedContentType;
    }

    public ResourcePriority getInitialPriority() {
        return this.initialPriority;
    }

    public ReferrerPolicy getReferrerPolicy() {
        return this.referrerPolicy;
    }

    public Boolean getIsLinkPreload() {
        return this.isLinkPreload;
    }

    private static Request fromJson(JsonInput input) {
        String url = null;
        String urlFragment = null;
        String method = null;
        Headers headers = null;
        String postData = null;
        Boolean hasPostData = null;
        MixedContentType mixedContentType = null;
        ResourcePriority initialPriority = null;
        ReferrerPolicy referrerPolicy = null;
        Boolean isLinkPreload = null;
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = input.nextString();
                    continue block24;
                }
                case "urlFragment": {
                    urlFragment = input.nextString();
                    continue block24;
                }
                case "method": {
                    method = input.nextString();
                    continue block24;
                }
                case "headers": {
                    headers = (Headers)((Object)input.read(Headers.class));
                    continue block24;
                }
                case "postData": {
                    postData = input.nextString();
                    continue block24;
                }
                case "hasPostData": {
                    hasPostData = input.nextBoolean();
                    continue block24;
                }
                case "mixedContentType": {
                    mixedContentType = (MixedContentType)((Object)input.read(MixedContentType.class));
                    continue block24;
                }
                case "initialPriority": {
                    initialPriority = (ResourcePriority)((Object)input.read(ResourcePriority.class));
                    continue block24;
                }
                case "referrerPolicy": {
                    referrerPolicy = ReferrerPolicy.fromString(input.nextString());
                    continue block24;
                }
                case "isLinkPreload": {
                    isLinkPreload = input.nextBoolean();
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Request(url, urlFragment, method, headers, postData, hasPostData, mixedContentType, initialPriority, referrerPolicy, isLinkPreload);
    }

    public static enum ReferrerPolicy {
        UNSAFE_URL("unsafe-url"),
        NO_REFERRER_WHEN_DOWNGRADE("no-referrer-when-downgrade"),
        NO_REFERRER("no-referrer"),
        ORIGIN("origin"),
        ORIGIN_WHEN_CROSS_ORIGIN("origin-when-cross-origin"),
        SAME_ORIGIN("same-origin"),
        STRICT_ORIGIN("strict-origin"),
        STRICT_ORIGIN_WHEN_CROSS_ORIGIN("strict-origin-when-cross-origin");

        private String value;

        private ReferrerPolicy(String value) {
            this.value = value;
        }

        public static ReferrerPolicy fromString(String s) {
            return Arrays.stream(ReferrerPolicy.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ReferrerPolicy "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static ReferrerPolicy fromJson(JsonInput input) {
            return ReferrerPolicy.fromString(input.nextString());
        }
    }
}

