/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.CookieSameSite;
import org.openqa.selenium.devtools.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

public class CookieParam {
    private final String name;
    private final String value;
    private final String url;
    private final String domain;
    private final String path;
    private final Boolean secure;
    private final Boolean httpOnly;
    private final CookieSameSite sameSite;
    private final TimeSinceEpoch expires;

    public CookieParam(String name, String value, String url, String domain, String path, Boolean secure, Boolean httpOnly, CookieSameSite sameSite, TimeSinceEpoch expires) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.url = url;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.sameSite = sameSite;
        this.expires = expires;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    public CookieSameSite getSameSite() {
        return this.sameSite;
    }

    public TimeSinceEpoch getExpires() {
        return this.expires;
    }

    private static CookieParam fromJson(JsonInput input) {
        String name = null;
        String value = null;
        String url = null;
        String domain = null;
        String path = null;
        Boolean secure = null;
        Boolean httpOnly = null;
        CookieSameSite sameSite = null;
        TimeSinceEpoch expires = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block22;
                }
                case "value": {
                    value = input.nextString();
                    continue block22;
                }
                case "url": {
                    url = input.nextString();
                    continue block22;
                }
                case "domain": {
                    domain = input.nextString();
                    continue block22;
                }
                case "path": {
                    path = input.nextString();
                    continue block22;
                }
                case "secure": {
                    secure = input.nextBoolean();
                    continue block22;
                }
                case "httpOnly": {
                    httpOnly = input.nextBoolean();
                    continue block22;
                }
                case "sameSite": {
                    sameSite = (CookieSameSite)((Object)input.read(CookieSameSite.class));
                    continue block22;
                }
                case "expires": {
                    expires = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CookieParam(name, value, url, domain, path, secure, httpOnly, sameSite, expires);
    }
}

