/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.debugger.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.debugger.model.Location;
import org.openqa.selenium.devtools.runtime.model.RemoteObject;
import org.openqa.selenium.json.JsonInput;

public class Scope {
    private final Type type;
    private final RemoteObject object;
    private final String name;
    private final Location startLocation;
    private final Location endLocation;

    public Scope(Type type, RemoteObject object, String name, Location startLocation, Location endLocation) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.object = Objects.requireNonNull(object, "object is required");
        this.name = name;
        this.startLocation = startLocation;
        this.endLocation = endLocation;
    }

    public Type getType() {
        return this.type;
    }

    public RemoteObject getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public Location getStartLocation() {
        return this.startLocation;
    }

    public Location getEndLocation() {
        return this.endLocation;
    }

    private static Scope fromJson(JsonInput input) {
        Type type = null;
        RemoteObject object = null;
        String name = null;
        Location startLocation = null;
        Location endLocation = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = Type.fromString(input.nextString());
                    continue block14;
                }
                case "object": {
                    object = (RemoteObject)input.read(RemoteObject.class);
                    continue block14;
                }
                case "name": {
                    name = input.nextString();
                    continue block14;
                }
                case "startLocation": {
                    startLocation = (Location)input.read(Location.class);
                    continue block14;
                }
                case "endLocation": {
                    endLocation = (Location)input.read(Location.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Scope(type, object, name, startLocation, endLocation);
    }

    public static enum Type {
        GLOBAL("global"),
        LOCAL("local"),
        WITH("with"),
        CLOSURE("closure"),
        CATCH("catch"),
        BLOCK("block"),
        SCRIPT("script"),
        EVAL("eval"),
        MODULE("module");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public static Type fromString(String s) {
            return Arrays.stream(Type.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Type "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Type fromJson(JsonInput input) {
            return Type.fromString(input.nextString());
        }
    }
}

