/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.profiler.model.TypeObject;
import org.openqa.selenium.json.JsonInput;

@Beta
public class TypeProfileEntry {
    private final int offset;
    private final List<TypeObject> types;

    public TypeProfileEntry(int offset, List<TypeObject> types) {
        this.validateTypes(types);
        this.offset = offset;
        this.types = types;
    }

    static TypeProfileEntry fromJson(JsonInput input) {
        int offset = (Integer)input.read(Integer.class);
        ArrayList<TypeObject> types = null;
        block6: while (input.hasNext()) {
            switch (input.nextName()) {
                case "types": {
                    types = new ArrayList<TypeObject>();
                    input.beginArray();
                    while (input.hasNext()) {
                        types.add((TypeObject)input.read(TypeObject.class));
                    }
                    input.endArray();
                    continue block6;
                }
            }
            input.skipValue();
        }
        return new TypeProfileEntry(offset, types);
    }

    public int getOffset() {
        return this.offset;
    }

    public List<TypeObject> getTypes() {
        return this.types;
    }

    public void validateTypes(List<TypeObject> types) {
        Objects.requireNonNull(types, "types is require");
        if (types.isEmpty()) {
            throw new DevToolsException("types is require");
        }
    }
}

