/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.profiler.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.network.model.CallFrame;
import org.openqa.selenium.devtools.profiler.model.PositionTickInfo;
import org.openqa.selenium.json.JsonInput;

public class ProfileNode {
    private final int id;
    private final CallFrame callFrame;
    private final Integer hitCount;
    private final List<Integer> children;
    private final String deoptReason;
    private final List<PositionTickInfo> positionTicks;

    public ProfileNode(int id, CallFrame callFrame, Integer hitCount, List<Integer> children, String deoptReason, List<PositionTickInfo> positionTicks) {
        Objects.requireNonNull(callFrame, "callFrame is mandatory");
        this.id = id;
        this.callFrame = callFrame;
        this.hitCount = hitCount;
        this.children = children;
        this.deoptReason = deoptReason;
        this.positionTicks = positionTicks;
    }

    private static ProfileNode fromJson(JsonInput input) {
        int id = -1;
        CallFrame callFrame = null;
        Integer hitCount = null;
        ArrayList<Integer> children = null;
        String dropReason = null;
        ArrayList<PositionTickInfo> positionTicks = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "id": {
                    id = (Integer)input.read(Integer.class);
                    continue block16;
                }
                case "callFrame": {
                    callFrame = (CallFrame)input.read(CallFrame.class);
                    continue block16;
                }
                case "hitCount": {
                    hitCount = (Integer)input.read(Integer.class);
                    continue block16;
                }
                case "children": {
                    children = new ArrayList<Integer>();
                    input.beginArray();
                    while (input.hasNext()) {
                        children.add((Integer)input.read(Integer.class));
                    }
                    input.endArray();
                    continue block16;
                }
                case "dropReason": {
                    dropReason = input.nextString();
                    continue block16;
                }
                case "positionTicks": {
                    positionTicks = new ArrayList<PositionTickInfo>();
                    input.beginArray();
                    while (input.hasNext()) {
                        positionTicks.add((PositionTickInfo)input.read(PositionTickInfo.class));
                    }
                    input.endArray();
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ProfileNode(id, callFrame, hitCount, children, dropReason, positionTicks);
    }

    public int getId() {
        return this.id;
    }

    public CallFrame getCallFrame() {
        return this.callFrame;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public List<Integer> getChildren() {
        return this.children;
    }

    public String getDeoptReason() {
        return this.deoptReason;
    }

    public List<PositionTickInfo> getPositionTicks() {
        return this.positionTicks;
    }
}

