/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class WebSocketFrame {
    private Number opcode;
    private boolean mask;
    private String payloadData;

    private WebSocketFrame(Number opcode, boolean mask, String payloadData) {
        this.opcode = Objects.requireNonNull(opcode, "'opcode' is required for WebSocketFrame");
        this.mask = mask;
        this.payloadData = Objects.requireNonNull(payloadData, "'payloadData' is required for WebSocketFrame");
    }

    private static WebSocketFrame fromJson(JsonInput input) {
        Number opcode = null;
        boolean mask = false;
        String payloadData = null;
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "opcode": {
                    opcode = input.nextNumber();
                    continue block10;
                }
                case "mask": {
                    mask = input.nextBoolean();
                    continue block10;
                }
                case "payloadData": {
                    payloadData = input.nextString();
                    continue block10;
                }
            }
            input.skipValue();
        }
        return new WebSocketFrame(opcode, mask, payloadData);
    }

    public Number getOpcode() {
        return this.opcode;
    }

    public boolean isMask() {
        return this.mask;
    }

    public String getPayloadData() {
        return this.payloadData;
    }
}

