/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.network.model.Initiator;
import org.openqa.selenium.devtools.network.model.LoaderId;
import org.openqa.selenium.devtools.network.model.MonotonicTime;
import org.openqa.selenium.devtools.network.model.Request;
import org.openqa.selenium.devtools.network.model.RequestId;
import org.openqa.selenium.devtools.network.model.ResourceType;
import org.openqa.selenium.devtools.network.model.Response;
import org.openqa.selenium.json.JsonInput;

public class RequestWillBeSent {
    private final RequestId requestId;
    private final LoaderId loaderId;
    private final String documentURL;
    private final Request request;
    private final MonotonicTime timestamp;
    private final Number wallTime;
    private final Initiator initiator;
    private final Response redirectResponse;
    private final ResourceType type;
    private final String frameId;
    private final Boolean hasUserGesture;

    private RequestWillBeSent(RequestId requestId, LoaderId loaderId, String documentURL, Request request, MonotonicTime timestamp, Number wallTime, Initiator initiator, Response redirectResponse, ResourceType type, String frameId, Boolean hasUserGesture) {
        this.requestId = Objects.requireNonNull(requestId, "'requestId' is required for RequestWillBeSent");
        this.loaderId = Objects.requireNonNull(loaderId, "'loaderId' is required for RequestWillBeSent");
        this.documentURL = Objects.requireNonNull(documentURL, "'documentURL' is required for RequestWillBeSent");
        this.request = Objects.requireNonNull(request, "'request' is required for RequestWillBeSent");
        this.timestamp = Objects.requireNonNull(timestamp, "'timestamp' is required for RequestWillBeSent");
        this.wallTime = Objects.requireNonNull(wallTime, "'wallTime' is required for RequestWillBeSent");
        this.initiator = Objects.requireNonNull(initiator, "'initiator' is required for RequestWillBeSent");
        this.redirectResponse = redirectResponse;
        this.type = type;
        this.frameId = frameId;
        this.hasUserGesture = hasUserGesture;
    }

    private static RequestWillBeSent fromJson(JsonInput input) {
        RequestId requestId = new RequestId(input.nextString());
        LoaderId loaderId = null;
        String documentURL = null;
        Request request = null;
        MonotonicTime timestamp = null;
        Number wallTime = null;
        Initiator initiator = null;
        Response redirectResponse = null;
        ResourceType type = null;
        String frameId = null;
        Boolean hasUserGesture = null;
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "loaderId": {
                    loaderId = new LoaderId(input.nextString());
                    continue block24;
                }
                case "documentURL": {
                    documentURL = input.nextString();
                    continue block24;
                }
                case "request": {
                    request = (Request)input.read(Request.class);
                    continue block24;
                }
                case "timestamp": {
                    timestamp = MonotonicTime.parse(input.nextNumber());
                    continue block24;
                }
                case "wallTime": {
                    wallTime = input.nextNumber();
                    continue block24;
                }
                case "initiator": {
                    initiator = (Initiator)input.read(Initiator.class);
                    continue block24;
                }
                case "redirectResponse": {
                    redirectResponse = (Response)input.read(Response.class);
                    continue block24;
                }
                case "type": {
                    type = ResourceType.valueOf(input.nextString());
                    continue block24;
                }
                case "frameId": {
                    frameId = input.nextString();
                    continue block24;
                }
                case "hasUserGesture": {
                    hasUserGesture = input.nextBoolean();
                    continue block24;
                }
            }
            input.skipValue();
        }
        return new RequestWillBeSent(requestId, loaderId, documentURL, request, timestamp, wallTime, initiator, redirectResponse, type, frameId, hasUserGesture);
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getDocumentURL() {
        return this.documentURL;
    }

    public Request getRequest() {
        return this.request;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public Number getWallTime() {
        return this.wallTime;
    }

    public Initiator getInitiator() {
        return this.initiator;
    }

    public Response getRedirectResponse() {
        return this.redirectResponse;
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getFrameId() {
        return this.frameId;
    }

    public Boolean getHasUserGesture() {
        return this.hasUserGesture;
    }

    public String toString() {
        return "RequestWillBeSent{requestId=" + this.requestId + ", loaderId=" + this.loaderId + ", documentURL='" + this.documentURL + '\'' + ", request=" + this.request + ", timestamp=" + this.timestamp.getTimeStamp().toString() + ", wallTime=" + this.wallTime + ", initiator=" + this.initiator + ", redirectResponse=" + this.redirectResponse + ", type=" + (Object)((Object)this.type) + ", frameId='" + this.frameId + '\'' + ", hasUserGesture=" + this.hasUserGesture + '}';
    }
}

