/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.applicationCache.model;

import java.util.Objects;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class ApplicationCacheStatusUpdated {
    private final FrameId frameId;
    private final String manifestURL;
    private final int status;

    public ApplicationCacheStatusUpdated(FrameId frameId, String manifestURL, int status) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.manifestURL = Objects.requireNonNull(manifestURL, "manifestURL is required");
        this.status = Objects.requireNonNull(Integer.valueOf(status), "status is required");
    }

    private static ApplicationCacheStatusUpdated fromJson(JsonInput input) {
        FrameId frameId = (FrameId)input.read(FrameId.class);
        String manifestURL = null;
        Integer status = null;
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "manifestURL": {
                    manifestURL = input.nextString();
                    continue block8;
                }
                case "status": {
                    status = (Integer)input.read(Integer.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        return new ApplicationCacheStatusUpdated(frameId, manifestURL, status);
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public String getManifestURL() {
        return this.manifestURL;
    }

    public int getStatus() {
        return this.status;
    }
}

