package org.openqa.selenium.devtools.v99.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class ScrollSnapHighlightConfig {

    private final org.openqa.selenium.devtools.v99.overlay.model.ScrollSnapContainerHighlightConfig scrollSnapContainerHighlightConfig;

    private final org.openqa.selenium.devtools.v99.dom.model.NodeId nodeId;

    public ScrollSnapHighlightConfig(org.openqa.selenium.devtools.v99.overlay.model.ScrollSnapContainerHighlightConfig scrollSnapContainerHighlightConfig, org.openqa.selenium.devtools.v99.dom.model.NodeId nodeId) {
        this.scrollSnapContainerHighlightConfig = java.util.Objects.requireNonNull(scrollSnapContainerHighlightConfig, "scrollSnapContainerHighlightConfig is required");
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
    }

    /**
     * A descriptor for the highlight appearance of scroll snap containers.
     */
    public org.openqa.selenium.devtools.v99.overlay.model.ScrollSnapContainerHighlightConfig getScrollSnapContainerHighlightConfig() {
        return scrollSnapContainerHighlightConfig;
    }

    /**
     * Identifier of the node to highlight.
     */
    public org.openqa.selenium.devtools.v99.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    private static ScrollSnapHighlightConfig fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v99.overlay.model.ScrollSnapContainerHighlightConfig scrollSnapContainerHighlightConfig = null;
        org.openqa.selenium.devtools.v99.dom.model.NodeId nodeId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "scrollSnapContainerHighlightConfig":
                    scrollSnapContainerHighlightConfig = input.read(org.openqa.selenium.devtools.v99.overlay.model.ScrollSnapContainerHighlightConfig.class);
                    break;
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v99.dom.model.NodeId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScrollSnapHighlightConfig(scrollSnapContainerHighlightConfig, nodeId);
    }
}
