/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v98.accessibility.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v98.accessibility.model.AXValue;
import org.openqa.selenium.devtools.v98.accessibility.model.AXValueNativeSourceType;
import org.openqa.selenium.devtools.v98.accessibility.model.AXValueSourceType;
import org.openqa.selenium.json.JsonInput;

public class AXValueSource {
    private final AXValueSourceType type;
    private final Optional<AXValue> value;
    private final Optional<String> attribute;
    private final Optional<AXValue> attributeValue;
    private final Optional<Boolean> superseded;
    private final Optional<AXValueNativeSourceType> nativeSource;
    private final Optional<AXValue> nativeSourceValue;
    private final Optional<Boolean> invalid;
    private final Optional<String> invalidReason;

    public AXValueSource(AXValueSourceType type, Optional<AXValue> value, Optional<String> attribute, Optional<AXValue> attributeValue, Optional<Boolean> superseded, Optional<AXValueNativeSourceType> nativeSource, Optional<AXValue> nativeSourceValue, Optional<Boolean> invalid, Optional<String> invalidReason) {
        this.type = Objects.requireNonNull(type, "type is required");
        this.value = value;
        this.attribute = attribute;
        this.attributeValue = attributeValue;
        this.superseded = superseded;
        this.nativeSource = nativeSource;
        this.nativeSourceValue = nativeSourceValue;
        this.invalid = invalid;
        this.invalidReason = invalidReason;
    }

    public AXValueSourceType getType() {
        return this.type;
    }

    public Optional<AXValue> getValue() {
        return this.value;
    }

    public Optional<String> getAttribute() {
        return this.attribute;
    }

    public Optional<AXValue> getAttributeValue() {
        return this.attributeValue;
    }

    public Optional<Boolean> getSuperseded() {
        return this.superseded;
    }

    public Optional<AXValueNativeSourceType> getNativeSource() {
        return this.nativeSource;
    }

    public Optional<AXValue> getNativeSourceValue() {
        return this.nativeSourceValue;
    }

    public Optional<Boolean> getInvalid() {
        return this.invalid;
    }

    public Optional<String> getInvalidReason() {
        return this.invalidReason;
    }

    private static AXValueSource fromJson(JsonInput input) {
        AXValueSourceType type = null;
        Optional<AXValue> value = Optional.empty();
        Optional<String> attribute = Optional.empty();
        Optional<AXValue> attributeValue = Optional.empty();
        Optional<Boolean> superseded = Optional.empty();
        Optional<AXValueNativeSourceType> nativeSource = Optional.empty();
        Optional<AXValue> nativeSourceValue = Optional.empty();
        Optional<Boolean> invalid = Optional.empty();
        Optional<String> invalidReason = Optional.empty();
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    type = (AXValueSourceType)((Object)input.read(AXValueSourceType.class));
                    continue block22;
                }
                case "value": {
                    value = Optional.ofNullable((AXValue)input.read(AXValue.class));
                    continue block22;
                }
                case "attribute": {
                    attribute = Optional.ofNullable(input.nextString());
                    continue block22;
                }
                case "attributeValue": {
                    attributeValue = Optional.ofNullable((AXValue)input.read(AXValue.class));
                    continue block22;
                }
                case "superseded": {
                    superseded = Optional.ofNullable(input.nextBoolean());
                    continue block22;
                }
                case "nativeSource": {
                    nativeSource = Optional.ofNullable((AXValueNativeSourceType)((Object)input.read(AXValueNativeSourceType.class)));
                    continue block22;
                }
                case "nativeSourceValue": {
                    nativeSourceValue = Optional.ofNullable((AXValue)input.read(AXValue.class));
                    continue block22;
                }
                case "invalid": {
                    invalid = Optional.ofNullable(input.nextBoolean());
                    continue block22;
                }
                case "invalidReason": {
                    invalidReason = Optional.ofNullable(input.nextString());
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AXValueSource(type, value, attribute, attributeValue, superseded, nativeSource, nativeSourceValue, invalid, invalidReason);
    }
}

