package org.openqa.selenium.devtools.v98.fetch.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Issued when the domain is enabled and the request URL matches the
 * specified filter. The request is paused until the client responds
 * with one of continueRequest, failRequest or fulfillRequest.
 * The stage of the request can be determined by presence of responseErrorReason
 * and responseStatusCode -- the request is at the response stage if either
 * of these fields is present and in the request stage otherwise.
 */
public class RequestPaused {

    private final org.openqa.selenium.devtools.v98.fetch.model.RequestId requestId;

    private final org.openqa.selenium.devtools.v98.network.model.Request request;

    private final org.openqa.selenium.devtools.v98.page.model.FrameId frameId;

    private final org.openqa.selenium.devtools.v98.network.model.ResourceType resourceType;

    private final java.util.Optional<org.openqa.selenium.devtools.v98.network.model.ErrorReason> responseErrorReason;

    private final java.util.Optional<java.lang.Integer> responseStatusCode;

    private final java.util.Optional<java.lang.String> responseStatusText;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v98.fetch.model.HeaderEntry>> responseHeaders;

    private final java.util.Optional<org.openqa.selenium.devtools.v98.fetch.model.RequestId> networkId;

    public RequestPaused(org.openqa.selenium.devtools.v98.fetch.model.RequestId requestId, org.openqa.selenium.devtools.v98.network.model.Request request, org.openqa.selenium.devtools.v98.page.model.FrameId frameId, org.openqa.selenium.devtools.v98.network.model.ResourceType resourceType, java.util.Optional<org.openqa.selenium.devtools.v98.network.model.ErrorReason> responseErrorReason, java.util.Optional<java.lang.Integer> responseStatusCode, java.util.Optional<java.lang.String> responseStatusText, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v98.fetch.model.HeaderEntry>> responseHeaders, java.util.Optional<org.openqa.selenium.devtools.v98.fetch.model.RequestId> networkId) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.request = java.util.Objects.requireNonNull(request, "request is required");
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.resourceType = java.util.Objects.requireNonNull(resourceType, "resourceType is required");
        this.responseErrorReason = responseErrorReason;
        this.responseStatusCode = responseStatusCode;
        this.responseStatusText = responseStatusText;
        this.responseHeaders = responseHeaders;
        this.networkId = networkId;
    }

    /**
     * Each request the page makes will have a unique id.
     */
    public org.openqa.selenium.devtools.v98.fetch.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * The details of the request.
     */
    public org.openqa.selenium.devtools.v98.network.model.Request getRequest() {
        return request;
    }

    /**
     * The id of the frame that initiated the request.
     */
    public org.openqa.selenium.devtools.v98.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * How the requested resource will be used.
     */
    public org.openqa.selenium.devtools.v98.network.model.ResourceType getResourceType() {
        return resourceType;
    }

    /**
     * Response error if intercepted at response stage.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v98.network.model.ErrorReason> getResponseErrorReason() {
        return responseErrorReason;
    }

    /**
     * Response code if intercepted at response stage.
     */
    public java.util.Optional<java.lang.Integer> getResponseStatusCode() {
        return responseStatusCode;
    }

    /**
     * Response status text if intercepted at response stage.
     */
    public java.util.Optional<java.lang.String> getResponseStatusText() {
        return responseStatusText;
    }

    /**
     * Response headers if intercepted at the response stage.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v98.fetch.model.HeaderEntry>> getResponseHeaders() {
        return responseHeaders;
    }

    /**
     * If the intercepted request had a corresponding Network.requestWillBeSent event fired for it,
     * then this networkId will be the same as the requestId present in the requestWillBeSent event.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v98.fetch.model.RequestId> getNetworkId() {
        return networkId;
    }

    private static RequestPaused fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v98.fetch.model.RequestId requestId = null;
        org.openqa.selenium.devtools.v98.network.model.Request request = null;
        org.openqa.selenium.devtools.v98.page.model.FrameId frameId = null;
        org.openqa.selenium.devtools.v98.network.model.ResourceType resourceType = null;
        java.util.Optional<org.openqa.selenium.devtools.v98.network.model.ErrorReason> responseErrorReason = java.util.Optional.empty();
        java.util.Optional<java.lang.Integer> responseStatusCode = java.util.Optional.empty();
        java.util.Optional<java.lang.String> responseStatusText = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v98.fetch.model.HeaderEntry>> responseHeaders = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v98.fetch.model.RequestId> networkId = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v98.fetch.model.RequestId.class);
                    break;
                case "request":
                    request = input.read(org.openqa.selenium.devtools.v98.network.model.Request.class);
                    break;
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v98.page.model.FrameId.class);
                    break;
                case "resourceType":
                    resourceType = input.read(org.openqa.selenium.devtools.v98.network.model.ResourceType.class);
                    break;
                case "responseErrorReason":
                    responseErrorReason = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v98.network.model.ErrorReason.class));
                    break;
                case "responseStatusCode":
                    responseStatusCode = java.util.Optional.ofNullable(input.nextNumber().intValue());
                    break;
                case "responseStatusText":
                    responseStatusText = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "responseHeaders":
                    responseHeaders = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v98.fetch.model.HeaderEntry>>() {
                    }.getType()));
                    break;
                case "networkId":
                    networkId = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v98.fetch.model.RequestId.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RequestPaused(requestId, request, frameId, resourceType, responseErrorReason, responseStatusCode, responseStatusText, responseHeaders, networkId);
    }
}
