/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v95;

import com.google.common.collect.ImmutableList;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.events.ConsoleEvent;
import org.openqa.selenium.devtools.idealized.Events;
import org.openqa.selenium.devtools.v95.runtime.Runtime;
import org.openqa.selenium.devtools.v95.runtime.model.ConsoleAPICalled;
import org.openqa.selenium.devtools.v95.runtime.model.ExceptionDetails;
import org.openqa.selenium.devtools.v95.runtime.model.ExceptionThrown;
import org.openqa.selenium.devtools.v95.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v95.runtime.model.StackTrace;

public class V95Events
extends Events<ConsoleAPICalled, ExceptionThrown> {
    public V95Events(DevTools devtools) {
        super(devtools);
    }

    protected Command<Void> enableRuntime() {
        return Runtime.enable();
    }

    protected Command<Void> disableRuntime() {
        return Runtime.disable();
    }

    protected Event<ConsoleAPICalled> consoleEvent() {
        return Runtime.consoleAPICalled();
    }

    protected Event<ExceptionThrown> exceptionThrownEvent() {
        return Runtime.exceptionThrown();
    }

    protected ConsoleEvent toConsoleEvent(ConsoleAPICalled event) {
        long ts = event.getTimestamp().toJson().longValue();
        List modifiedArgs = (List)event.getArgs().stream().map(obj -> new org.openqa.selenium.devtools.idealized.runtime.model.RemoteObject(obj.getType().toString(), obj.getValue().orElse(null))).collect(ImmutableList.toImmutableList());
        return new ConsoleEvent(event.getType().toString(), Instant.ofEpochMilli(ts), new Object[]{modifiedArgs});
    }

    protected JavascriptException toJsException(ExceptionThrown event) {
        ExceptionDetails details = event.getExceptionDetails();
        Optional<StackTrace> maybeTrace = details.getStackTrace();
        Optional<RemoteObject> maybeException = details.getException();
        String message = maybeException.flatMap(obj -> obj.getDescription().map(String::toString)).orElseGet(details::getText);
        JavascriptException exception = new JavascriptException(message);
        if (!maybeTrace.isPresent()) {
            StackTraceElement element = new StackTraceElement("unknown", "unknown", details.getUrl().orElse("unknown"), details.getLineNumber());
            exception.setStackTrace(new StackTraceElement[]{element});
            return exception;
        }
        StackTrace trace = maybeTrace.get();
        exception.setStackTrace((StackTraceElement[])trace.getCallFrames().stream().map(frame -> new StackTraceElement("", frame.getFunctionName(), frame.getUrl(), frame.getLineNumber())).toArray(StackTraceElement[]::new));
        return exception;
    }
}

