/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v94.fetch;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v94.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v94.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.v94.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.v94.fetch.model.RequestId;
import org.openqa.selenium.devtools.v94.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.v94.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.v94.io.model.StreamHandle;
import org.openqa.selenium.devtools.v94.network.model.ErrorReason;
import org.openqa.selenium.json.JsonInput;

public class Fetch {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Fetch.disable", (Map)params.build());
    }

    public static Command<Void> enable(Optional<List<RequestPattern>> patterns, Optional<Boolean> handleAuthRequests) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        patterns.ifPresent(p -> params.put((Object)"patterns", p));
        handleAuthRequests.ifPresent(p -> params.put((Object)"handleAuthRequests", p));
        return new Command("Fetch.enable", (Map)params.build());
    }

    public static Command<Void> failRequest(RequestId requestId, ErrorReason errorReason) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(errorReason, "errorReason is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        params.put((Object)"errorReason", (Object)errorReason);
        return new Command("Fetch.failRequest", (Map)params.build());
    }

    public static Command<Void> fulfillRequest(RequestId requestId, Integer responseCode, Optional<List<HeaderEntry>> responseHeaders, Optional<String> binaryResponseHeaders, Optional<String> body, Optional<String> responsePhrase) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(responseCode, "responseCode is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        params.put((Object)"responseCode", (Object)responseCode);
        responseHeaders.ifPresent(p -> params.put((Object)"responseHeaders", p));
        binaryResponseHeaders.ifPresent(p -> params.put((Object)"binaryResponseHeaders", p));
        body.ifPresent(p -> params.put((Object)"body", p));
        responsePhrase.ifPresent(p -> params.put((Object)"responsePhrase", p));
        return new Command("Fetch.fulfillRequest", (Map)params.build());
    }

    public static Command<Void> continueRequest(RequestId requestId, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<List<HeaderEntry>> headers, Optional<Boolean> interceptResponse) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        url.ifPresent(p -> params.put((Object)"url", p));
        method.ifPresent(p -> params.put((Object)"method", p));
        postData.ifPresent(p -> params.put((Object)"postData", p));
        headers.ifPresent(p -> params.put((Object)"headers", p));
        interceptResponse.ifPresent(p -> params.put((Object)"interceptResponse", p));
        return new Command("Fetch.continueRequest", (Map)params.build());
    }

    public static Command<Void> continueWithAuth(RequestId requestId, AuthChallengeResponse authChallengeResponse) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(authChallengeResponse, "authChallengeResponse is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        params.put((Object)"authChallengeResponse", (Object)authChallengeResponse);
        return new Command("Fetch.continueWithAuth", (Map)params.build());
    }

    public static Command<GetResponseBodyResponse> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        return new Command("Fetch.getResponseBody", (Map)params.build(), input -> (GetResponseBodyResponse)input.read(GetResponseBodyResponse.class));
    }

    public static Command<StreamHandle> takeResponseBodyAsStream(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        return new Command("Fetch.takeResponseBodyAsStream", (Map)params.build(), ConverterFunctions.map((String)"stream", StreamHandle.class));
    }

    public static Event<RequestPaused> requestPaused() {
        return new Event("Fetch.requestPaused", input -> (RequestPaused)input.read(RequestPaused.class));
    }

    public static Event<AuthRequired> authRequired() {
        return new Event("Fetch.authRequired", input -> (AuthRequired)input.read(AuthRequired.class));
    }

    public static class GetResponseBodyResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyResponse(body, base64Encoded);
        }
    }
}

