/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v94.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v94.network.model.RequestId;
import org.openqa.selenium.json.JsonInput;

public class AffectedRequest {
    private final RequestId requestId;
    private final Optional<String> url;

    public AffectedRequest(RequestId requestId, Optional<String> url) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.url = url;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    private static AffectedRequest fromJson(JsonInput input) {
        RequestId requestId = null;
        Optional<String> url = Optional.empty();
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block8;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AffectedRequest(requestId, url);
    }
}

