package org.openqa.selenium.devtools.v94.profiler.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Runtime call counter information.
 */
@org.openqa.selenium.Beta()
public class RuntimeCallCounterInfo {

    private final java.lang.String name;

    private final java.lang.Number value;

    private final java.lang.Number time;

    public RuntimeCallCounterInfo(java.lang.String name, java.lang.Number value, java.lang.Number time) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
        this.time = java.util.Objects.requireNonNull(time, "time is required");
    }

    /**
     * Counter name.
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * Counter value.
     */
    public java.lang.Number getValue() {
        return value;
    }

    /**
     * Counter time in seconds.
     */
    public java.lang.Number getTime() {
        return time;
    }

    private static RuntimeCallCounterInfo fromJson(JsonInput input) {
        java.lang.String name = null;
        java.lang.Number value = 0;
        java.lang.Number time = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "value":
                    value = input.nextNumber();
                    break;
                case "time":
                    time = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RuntimeCallCounterInfo(name, value, time);
    }
}
