package org.openqa.selenium.devtools.v93.input.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class DragData {

    private final java.util.List<org.openqa.selenium.devtools.v93.input.model.DragDataItem> items;

    private final java.lang.Integer dragOperationsMask;

    public DragData(java.util.List<org.openqa.selenium.devtools.v93.input.model.DragDataItem> items, java.lang.Integer dragOperationsMask) {
        this.items = java.util.Objects.requireNonNull(items, "items is required");
        this.dragOperationsMask = java.util.Objects.requireNonNull(dragOperationsMask, "dragOperationsMask is required");
    }

    public java.util.List<org.openqa.selenium.devtools.v93.input.model.DragDataItem> getItems() {
        return items;
    }

    /**
     * Bit field representing allowed drag operations. Copy = 1, Link = 2, Move = 16
     */
    public java.lang.Integer getDragOperationsMask() {
        return dragOperationsMask;
    }

    private static DragData fromJson(JsonInput input) {
        java.util.List<org.openqa.selenium.devtools.v93.input.model.DragDataItem> items = null;
        java.lang.Integer dragOperationsMask = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "items":
                    items = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v93.input.model.DragDataItem>>() {
                    }.getType());
                    break;
                case "dragOperationsMask":
                    dragOperationsMask = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new DragData(items, dragOperationsMask);
    }
}
