/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.animation;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v91.runtime.model.RemoteObject;

@Beta
public class Animation {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Animation.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Animation.enable", (Map)params.build());
    }

    public static Command<Number> getCurrentTime(String id) {
        Objects.requireNonNull(id, "id is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"id", (Object)id);
        return new Command("Animation.getCurrentTime", (Map)params.build(), ConverterFunctions.map((String)"currentTime", Number.class));
    }

    public static Command<Number> getPlaybackRate() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Animation.getPlaybackRate", (Map)params.build(), ConverterFunctions.map((String)"playbackRate", Number.class));
    }

    public static Command<Void> releaseAnimations(List<String> animations) {
        Objects.requireNonNull(animations, "animations is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animations", animations);
        return new Command("Animation.releaseAnimations", (Map)params.build());
    }

    public static Command<RemoteObject> resolveAnimation(String animationId) {
        Objects.requireNonNull(animationId, "animationId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animationId", (Object)animationId);
        return new Command("Animation.resolveAnimation", (Map)params.build(), ConverterFunctions.map((String)"remoteObject", RemoteObject.class));
    }

    public static Command<Void> seekAnimations(List<String> animations, Number currentTime) {
        Objects.requireNonNull(animations, "animations is required");
        Objects.requireNonNull(currentTime, "currentTime is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animations", animations);
        params.put((Object)"currentTime", (Object)currentTime);
        return new Command("Animation.seekAnimations", (Map)params.build());
    }

    public static Command<Void> setPaused(List<String> animations, Boolean paused) {
        Objects.requireNonNull(animations, "animations is required");
        Objects.requireNonNull(paused, "paused is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animations", animations);
        params.put((Object)"paused", (Object)paused);
        return new Command("Animation.setPaused", (Map)params.build());
    }

    public static Command<Void> setPlaybackRate(Number playbackRate) {
        Objects.requireNonNull(playbackRate, "playbackRate is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"playbackRate", (Object)playbackRate);
        return new Command("Animation.setPlaybackRate", (Map)params.build());
    }

    public static Command<Void> setTiming(String animationId, Number duration, Number delay) {
        Objects.requireNonNull(animationId, "animationId is required");
        Objects.requireNonNull(duration, "duration is required");
        Objects.requireNonNull(delay, "delay is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"animationId", (Object)animationId);
        params.put((Object)"duration", (Object)duration);
        params.put((Object)"delay", (Object)delay);
        return new Command("Animation.setTiming", (Map)params.build());
    }

    public static Event<String> animationCanceled() {
        return new Event("Animation.animationCanceled", ConverterFunctions.map((String)"id", String.class));
    }

    public static Event<String> animationCreated() {
        return new Event("Animation.animationCreated", ConverterFunctions.map((String)"id", String.class));
    }

    public static Event<org.openqa.selenium.devtools.v91.animation.model.Animation> animationStarted() {
        return new Event("Animation.animationStarted", ConverterFunctions.map((String)"animation", org.openqa.selenium.devtools.v91.animation.model.Animation.class));
    }
}

