/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.webaudio.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v91.webaudio.model.GraphObjectId;
import org.openqa.selenium.json.JsonInput;

public class NodesConnected {
    private final GraphObjectId contextId;
    private final GraphObjectId sourceId;
    private final GraphObjectId destinationId;
    private final Optional<Number> sourceOutputIndex;
    private final Optional<Number> destinationInputIndex;

    public NodesConnected(GraphObjectId contextId, GraphObjectId sourceId, GraphObjectId destinationId, Optional<Number> sourceOutputIndex, Optional<Number> destinationInputIndex) {
        this.contextId = Objects.requireNonNull(contextId, "contextId is required");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is required");
        this.destinationId = Objects.requireNonNull(destinationId, "destinationId is required");
        this.sourceOutputIndex = sourceOutputIndex;
        this.destinationInputIndex = destinationInputIndex;
    }

    public GraphObjectId getContextId() {
        return this.contextId;
    }

    public GraphObjectId getSourceId() {
        return this.sourceId;
    }

    public GraphObjectId getDestinationId() {
        return this.destinationId;
    }

    public Optional<Number> getSourceOutputIndex() {
        return this.sourceOutputIndex;
    }

    public Optional<Number> getDestinationInputIndex() {
        return this.destinationInputIndex;
    }

    private static NodesConnected fromJson(JsonInput input) {
        GraphObjectId contextId = null;
        GraphObjectId sourceId = null;
        GraphObjectId destinationId = null;
        Optional<Number> sourceOutputIndex = Optional.empty();
        Optional<Number> destinationInputIndex = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "contextId": {
                    contextId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block14;
                }
                case "sourceId": {
                    sourceId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block14;
                }
                case "destinationId": {
                    destinationId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block14;
                }
                case "sourceOutputIndex": {
                    sourceOutputIndex = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
                case "destinationInputIndex": {
                    destinationInputIndex = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NodesConnected(contextId, sourceId, destinationId, sourceOutputIndex, destinationInputIndex);
    }
}

