/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v91.css.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v91.css.model.CSSRule;
import org.openqa.selenium.json.JsonInput;

public class RuleMatch {
    private final CSSRule rule;
    private final List<Integer> matchingSelectors;

    public RuleMatch(CSSRule rule, List<Integer> matchingSelectors) {
        this.rule = Objects.requireNonNull(rule, "rule is required");
        this.matchingSelectors = Objects.requireNonNull(matchingSelectors, "matchingSelectors is required");
    }

    public CSSRule getRule() {
        return this.rule;
    }

    public List<Integer> getMatchingSelectors() {
        return this.matchingSelectors;
    }

    private static RuleMatch fromJson(JsonInput input) {
        CSSRule rule = null;
        List matchingSelectors = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "rule": {
                    rule = (CSSRule)input.read(CSSRule.class);
                    continue block8;
                }
                case "matchingSelectors": {
                    matchingSelectors = (List)input.read(new TypeToken<List<Integer>>(){}.getType());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RuleMatch(rule, matchingSelectors);
    }
}

