package org.openqa.selenium.devtools.v90.profiler.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Reports coverage delta since the last poll (either from an event like this, or from
 * `takePreciseCoverage` for the current isolate. May only be sent if precise code
 * coverage has been started. This event can be trigged by the embedder to, for example,
 * trigger collection of coverage data immediatelly at a certain point in time.
 */
@org.openqa.selenium.Beta()
public class PreciseCoverageDeltaUpdate {

    private final java.lang.Number timestamp;

    private final java.lang.String occassion;

    private final java.util.List<org.openqa.selenium.devtools.v90.profiler.model.ScriptCoverage> result;

    public PreciseCoverageDeltaUpdate(java.lang.Number timestamp, java.lang.String occassion, java.util.List<org.openqa.selenium.devtools.v90.profiler.model.ScriptCoverage> result) {
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.occassion = java.util.Objects.requireNonNull(occassion, "occassion is required");
        this.result = java.util.Objects.requireNonNull(result, "result is required");
    }

    /**
     * Monotonically increasing time (in seconds) when the coverage update was taken in the backend.
     */
    public java.lang.Number getTimestamp() {
        return timestamp;
    }

    /**
     * Identifier for distinguishing coverage events.
     */
    public java.lang.String getOccassion() {
        return occassion;
    }

    /**
     * Coverage data for the current isolate.
     */
    public java.util.List<org.openqa.selenium.devtools.v90.profiler.model.ScriptCoverage> getResult() {
        return result;
    }

    private static PreciseCoverageDeltaUpdate fromJson(JsonInput input) {
        java.lang.Number timestamp = 0;
        java.lang.String occassion = null;
        java.util.List<org.openqa.selenium.devtools.v90.profiler.model.ScriptCoverage> result = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "timestamp":
                    timestamp = input.nextNumber();
                    break;
                case "occassion":
                    occassion = input.nextString();
                    break;
                case "result":
                    result = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v90.profiler.model.ScriptCoverage>>() {
                    }.getType());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PreciseCoverageDeltaUpdate(timestamp, occassion, result);
    }
}
