package org.openqa.selenium.devtools.v90.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum SameSiteCookieExclusionReason {

    EXCLUDESAMESITEUNSPECIFIEDTREATEDASLAX("ExcludeSameSiteUnspecifiedTreatedAsLax"), EXCLUDESAMESITENONEINSECURE("ExcludeSameSiteNoneInsecure"), EXCLUDESAMESITELAX("ExcludeSameSiteLax"), EXCLUDESAMESITESTRICT("ExcludeSameSiteStrict");

    private String value;

    SameSiteCookieExclusionReason(String value) {
        this.value = value;
    }

    public static SameSiteCookieExclusionReason fromString(String s) {
        return java.util.Arrays.stream(SameSiteCookieExclusionReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within SameSiteCookieExclusionReason "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static SameSiteCookieExclusionReason fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
