package org.openqa.selenium.devtools.v90.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * A unique identifier for the type of issue. Each type may use one of the
 * optional fields in InspectorIssueDetails to convey more specific
 * information about the kind of issue.
 */
public enum InspectorIssueCode {

    SAMESITECOOKIEISSUE("SameSiteCookieIssue"),
    MIXEDCONTENTISSUE("MixedContentIssue"),
    BLOCKEDBYRESPONSEISSUE("BlockedByResponseIssue"),
    HEAVYADISSUE("HeavyAdIssue"),
    CONTENTSECURITYPOLICYISSUE("ContentSecurityPolicyIssue"),
    SHAREDARRAYBUFFERISSUE("SharedArrayBufferIssue"),
    TRUSTEDWEBACTIVITYISSUE("TrustedWebActivityIssue"),
    LOWTEXTCONTRASTISSUE("LowTextContrastIssue"),
    CORSISSUE("CorsIssue");

    private String value;

    InspectorIssueCode(String value) {
        this.value = value;
    }

    public static InspectorIssueCode fromString(String s) {
        return java.util.Arrays.stream(InspectorIssueCode.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within InspectorIssueCode "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static InspectorIssueCode fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
