package org.openqa.selenium.devtools.v89.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Indicates whether a frame has been identified as an ad.
 */
@org.openqa.selenium.Beta()
public enum AdFrameType {

    NONE("none"), CHILD("child"), ROOT("root");

    private String value;

    AdFrameType(String value) {
        this.value = value;
    }

    public static AdFrameType fromString(String s) {
        return java.util.Arrays.stream(AdFrameType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AdFrameType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AdFrameType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
