/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v89.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v89.network.model.CookiePriority;
import org.openqa.selenium.devtools.v89.network.model.CookieSameSite;
import org.openqa.selenium.json.JsonInput;

public class Cookie {
    private final String name;
    private final String value;
    private final String domain;
    private final String path;
    private final Number expires;
    private final Integer size;
    private final Boolean httpOnly;
    private final Boolean secure;
    private final Boolean session;
    private final Optional<CookieSameSite> sameSite;
    private final CookiePriority priority;

    public Cookie(String name, String value, String domain, String path, Number expires, Integer size, Boolean httpOnly, Boolean secure, Boolean session, Optional<CookieSameSite> sameSite, CookiePriority priority) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.domain = Objects.requireNonNull(domain, "domain is required");
        this.path = Objects.requireNonNull(path, "path is required");
        this.expires = Objects.requireNonNull(expires, "expires is required");
        this.size = Objects.requireNonNull(size, "size is required");
        this.httpOnly = Objects.requireNonNull(httpOnly, "httpOnly is required");
        this.secure = Objects.requireNonNull(secure, "secure is required");
        this.session = Objects.requireNonNull(session, "session is required");
        this.sameSite = sameSite;
        this.priority = Objects.requireNonNull(priority, "priority is required");
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public Number getExpires() {
        return this.expires;
    }

    public Integer getSize() {
        return this.size;
    }

    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public Boolean getSession() {
        return this.session;
    }

    public Optional<CookieSameSite> getSameSite() {
        return this.sameSite;
    }

    @Beta
    public CookiePriority getPriority() {
        return this.priority;
    }

    private static Cookie fromJson(JsonInput input) {
        String name = null;
        String value = null;
        String domain = null;
        String path = null;
        Number expires = 0;
        Integer size = 0;
        Boolean httpOnly = false;
        Boolean secure = false;
        Boolean session = false;
        Optional<CookieSameSite> sameSite = Optional.empty();
        CookiePriority priority = null;
        input.beginObject();
        block26: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block26;
                }
                case "value": {
                    value = input.nextString();
                    continue block26;
                }
                case "domain": {
                    domain = input.nextString();
                    continue block26;
                }
                case "path": {
                    path = input.nextString();
                    continue block26;
                }
                case "expires": {
                    expires = input.nextNumber();
                    continue block26;
                }
                case "size": {
                    size = input.nextNumber().intValue();
                    continue block26;
                }
                case "httpOnly": {
                    httpOnly = input.nextBoolean();
                    continue block26;
                }
                case "secure": {
                    secure = input.nextBoolean();
                    continue block26;
                }
                case "session": {
                    session = input.nextBoolean();
                    continue block26;
                }
                case "sameSite": {
                    sameSite = Optional.ofNullable((CookieSameSite)((Object)input.read(CookieSameSite.class)));
                    continue block26;
                }
                case "priority": {
                    priority = (CookiePriority)((Object)input.read(CookiePriority.class));
                    continue block26;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Cookie(name, value, domain, path, expires, size, httpOnly, secure, session, sameSite, priority);
    }
}

