package org.openqa.selenium.devtools.v88.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration data for the highlighting of Flex container elements.
 */
public class FlexContainerHighlightConfig {

    private final java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> containerBorder;

    private final java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> lineSeparator;

    private final java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> itemSeparator;

    public FlexContainerHighlightConfig(java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> containerBorder, java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> lineSeparator, java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> itemSeparator) {
        this.containerBorder = containerBorder;
        this.lineSeparator = lineSeparator;
        this.itemSeparator = itemSeparator;
    }

    /**
     * The style of the container border
     */
    public java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> getContainerBorder() {
        return containerBorder;
    }

    /**
     * The style of the separator between lines
     */
    public java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> getLineSeparator() {
        return lineSeparator;
    }

    /**
     * The style of the separator between items
     */
    public java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> getItemSeparator() {
        return itemSeparator;
    }

    private static FlexContainerHighlightConfig fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> containerBorder = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> lineSeparator = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v88.overlay.model.LineStyle> itemSeparator = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "containerBorder":
                    containerBorder = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v88.overlay.model.LineStyle.class));
                    break;
                case "lineSeparator":
                    lineSeparator = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v88.overlay.model.LineStyle.class));
                    break;
                case "itemSeparator":
                    itemSeparator = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v88.overlay.model.LineStyle.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FlexContainerHighlightConfig(containerBorder, lineSeparator, itemSeparator);
    }
}
