package org.openqa.selenium.devtools.v88.media.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Corresponds to kMediaEventTriggered
 */
public class PlayerEvent {

    private final org.openqa.selenium.devtools.v88.media.model.Timestamp timestamp;

    private final java.lang.String value;

    public PlayerEvent(org.openqa.selenium.devtools.v88.media.model.Timestamp timestamp, java.lang.String value) {
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.value = java.util.Objects.requireNonNull(value, "value is required");
    }

    public org.openqa.selenium.devtools.v88.media.model.Timestamp getTimestamp() {
        return timestamp;
    }

    public java.lang.String getValue() {
        return value;
    }

    private static PlayerEvent fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v88.media.model.Timestamp timestamp = null;
        java.lang.String value = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v88.media.model.Timestamp.class);
                    break;
                case "value":
                    value = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PlayerEvent(timestamp, value);
    }
}
