/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v88.css.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v88.css.model.CSSStyle;
import org.openqa.selenium.devtools.v88.css.model.RuleMatch;
import org.openqa.selenium.json.JsonInput;

public class InheritedStyleEntry {
    private final Optional<CSSStyle> inlineStyle;
    private final List<RuleMatch> matchedCSSRules;

    public InheritedStyleEntry(Optional<CSSStyle> inlineStyle, List<RuleMatch> matchedCSSRules) {
        this.inlineStyle = inlineStyle;
        this.matchedCSSRules = Objects.requireNonNull(matchedCSSRules, "matchedCSSRules is required");
    }

    public Optional<CSSStyle> getInlineStyle() {
        return this.inlineStyle;
    }

    public List<RuleMatch> getMatchedCSSRules() {
        return this.matchedCSSRules;
    }

    private static InheritedStyleEntry fromJson(JsonInput input) {
        Optional<CSSStyle> inlineStyle = Optional.empty();
        List matchedCSSRules = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "inlineStyle": {
                    inlineStyle = Optional.ofNullable((CSSStyle)input.read(CSSStyle.class));
                    continue block8;
                }
                case "matchedCSSRules": {
                    matchedCSSRules = (List)input.read(new TypeToken<List<RuleMatch>>(){}.getType());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InheritedStyleEntry(inlineStyle, matchedCSSRules);
    }
}

