/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v87.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v87.network.model.Cookie;
import org.openqa.selenium.devtools.v87.network.model.SetCookieBlockedReason;
import org.openqa.selenium.json.JsonInput;

@Beta
public class BlockedSetCookieWithReason {
    private final List<SetCookieBlockedReason> blockedReasons;
    private final String cookieLine;
    private final Optional<Cookie> cookie;

    public BlockedSetCookieWithReason(List<SetCookieBlockedReason> blockedReasons, String cookieLine, Optional<Cookie> cookie) {
        this.blockedReasons = Objects.requireNonNull(blockedReasons, "blockedReasons is required");
        this.cookieLine = Objects.requireNonNull(cookieLine, "cookieLine is required");
        this.cookie = cookie;
    }

    public List<SetCookieBlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    public String getCookieLine() {
        return this.cookieLine;
    }

    public Optional<Cookie> getCookie() {
        return this.cookie;
    }

    private static BlockedSetCookieWithReason fromJson(JsonInput input) {
        List blockedReasons = null;
        String cookieLine = null;
        Optional<Cookie> cookie = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "blockedReasons": {
                    blockedReasons = (List)input.read(new TypeToken<List<SetCookieBlockedReason>>(){}.getType());
                    continue block10;
                }
                case "cookieLine": {
                    cookieLine = input.nextString();
                    continue block10;
                }
                case "cookie": {
                    cookie = Optional.ofNullable((Cookie)input.read(Cookie.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BlockedSetCookieWithReason(blockedReasons, cookieLine, cookie);
    }
}

