/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v87.dom;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v87.dom.model.AttributeModified;
import org.openqa.selenium.devtools.v87.dom.model.AttributeRemoved;
import org.openqa.selenium.devtools.v87.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v87.dom.model.BoxModel;
import org.openqa.selenium.devtools.v87.dom.model.CSSComputedStyleProperty;
import org.openqa.selenium.devtools.v87.dom.model.CharacterDataModified;
import org.openqa.selenium.devtools.v87.dom.model.ChildNodeCountUpdated;
import org.openqa.selenium.devtools.v87.dom.model.ChildNodeInserted;
import org.openqa.selenium.devtools.v87.dom.model.ChildNodeRemoved;
import org.openqa.selenium.devtools.v87.dom.model.DistributedNodesUpdated;
import org.openqa.selenium.devtools.v87.dom.model.Node;
import org.openqa.selenium.devtools.v87.dom.model.NodeId;
import org.openqa.selenium.devtools.v87.dom.model.PseudoElementAdded;
import org.openqa.selenium.devtools.v87.dom.model.PseudoElementRemoved;
import org.openqa.selenium.devtools.v87.dom.model.Quad;
import org.openqa.selenium.devtools.v87.dom.model.Rect;
import org.openqa.selenium.devtools.v87.dom.model.SetChildNodes;
import org.openqa.selenium.devtools.v87.dom.model.ShadowRootPopped;
import org.openqa.selenium.devtools.v87.dom.model.ShadowRootPushed;
import org.openqa.selenium.devtools.v87.page.model.FrameId;
import org.openqa.selenium.devtools.v87.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v87.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v87.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v87.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class DOM {
    @Beta
    public static Command<List<String>> collectClassNamesFromSubtree(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("DOM.collectClassNamesFromSubtree", (Map)params.build(), ConverterFunctions.map((String)"classNames", (Type)new TypeToken<List<String>>(){}.getType()));
    }

    @Beta
    public static Command<NodeId> copyTo(NodeId nodeId, NodeId targetNodeId, Optional<NodeId> insertBeforeNodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(targetNodeId, "targetNodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"targetNodeId", (Object)targetNodeId);
        insertBeforeNodeId.ifPresent(p -> params.put((Object)"insertBeforeNodeId", p));
        return new Command("DOM.copyTo", (Map)params.build(), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Command<Node> describeNode(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command("DOM.describeNode", (Map)params.build(), ConverterFunctions.map((String)"node", Node.class));
    }

    @Beta
    public static Command<Void> scrollIntoViewIfNeeded(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Rect> rect) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        rect.ifPresent(p -> params.put((Object)"rect", p));
        return new Command("DOM.scrollIntoViewIfNeeded", (Map)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOM.disable", (Map)params.build());
    }

    @Beta
    public static Command<Void> discardSearchResults(String searchId) {
        Objects.requireNonNull(searchId, "searchId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"searchId", (Object)searchId);
        return new Command("DOM.discardSearchResults", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOM.enable", (Map)params.build());
    }

    public static Command<Void> focus(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command("DOM.focus", (Map)params.build());
    }

    public static Command<List<String>> getAttributes(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("DOM.getAttributes", (Map)params.build(), ConverterFunctions.map((String)"attributes", (Type)new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<BoxModel> getBoxModel(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command("DOM.getBoxModel", (Map)params.build(), ConverterFunctions.map((String)"model", BoxModel.class));
    }

    @Beta
    public static Command<List<Quad>> getContentQuads(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command("DOM.getContentQuads", (Map)params.build(), ConverterFunctions.map((String)"quads", (Type)new TypeToken<List<Quad>>(){}.getType()));
    }

    public static Command<Node> getDocument(Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command("DOM.getDocument", (Map)params.build(), ConverterFunctions.map((String)"root", Node.class));
    }

    @Deprecated
    public static Command<List<Node>> getFlattenedDocument(Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command("DOM.getFlattenedDocument", (Map)params.build(), ConverterFunctions.map((String)"nodes", (Type)new TypeToken<List<Node>>(){}.getType()));
    }

    @Beta
    public static Command<List<NodeId>> getNodesForSubtreeByStyle(NodeId nodeId, List<CSSComputedStyleProperty> computedStyles, Optional<Boolean> pierce) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(computedStyles, "computedStyles is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"computedStyles", computedStyles);
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command("DOM.getNodesForSubtreeByStyle", (Map)params.build(), ConverterFunctions.map((String)"nodeIds", (Type)new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<GetNodeForLocationResponse> getNodeForLocation(Integer x, Integer y, Optional<Boolean> includeUserAgentShadowDOM, Optional<Boolean> ignorePointerEventsNone) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        includeUserAgentShadowDOM.ifPresent(p -> params.put((Object)"includeUserAgentShadowDOM", p));
        ignorePointerEventsNone.ifPresent(p -> params.put((Object)"ignorePointerEventsNone", p));
        return new Command("DOM.getNodeForLocation", (Map)params.build(), input -> (GetNodeForLocationResponse)input.read(GetNodeForLocationResponse.class));
    }

    public static Command<String> getOuterHTML(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command("DOM.getOuterHTML", (Map)params.build(), ConverterFunctions.map((String)"outerHTML", String.class));
    }

    @Beta
    public static Command<NodeId> getRelayoutBoundary(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("DOM.getRelayoutBoundary", (Map)params.build(), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> getSearchResults(String searchId, Integer fromIndex, Integer toIndex) {
        Objects.requireNonNull(searchId, "searchId is required");
        Objects.requireNonNull(fromIndex, "fromIndex is required");
        Objects.requireNonNull(toIndex, "toIndex is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"searchId", (Object)searchId);
        params.put((Object)"fromIndex", (Object)fromIndex);
        params.put((Object)"toIndex", (Object)toIndex);
        return new Command("DOM.getSearchResults", (Map)params.build(), ConverterFunctions.map((String)"nodeIds", (Type)new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<Void> hideHighlight() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOM.hideHighlight", (Map)params.build());
    }

    public static Command<Void> highlightNode() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOM.highlightNode", (Map)params.build());
    }

    public static Command<Void> highlightRect() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOM.highlightRect", (Map)params.build());
    }

    @Beta
    public static Command<Void> markUndoableState() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOM.markUndoableState", (Map)params.build());
    }

    public static Command<NodeId> moveTo(NodeId nodeId, NodeId targetNodeId, Optional<NodeId> insertBeforeNodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(targetNodeId, "targetNodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"targetNodeId", (Object)targetNodeId);
        insertBeforeNodeId.ifPresent(p -> params.put((Object)"insertBeforeNodeId", p));
        return new Command("DOM.moveTo", (Map)params.build(), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    @Beta
    public static Command<PerformSearchResponse> performSearch(String query, Optional<Boolean> includeUserAgentShadowDOM) {
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"query", (Object)query);
        includeUserAgentShadowDOM.ifPresent(p -> params.put((Object)"includeUserAgentShadowDOM", p));
        return new Command("DOM.performSearch", (Map)params.build(), input -> (PerformSearchResponse)input.read(PerformSearchResponse.class));
    }

    @Beta
    public static Command<NodeId> pushNodeByPathToFrontend(String path) {
        Objects.requireNonNull(path, "path is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"path", (Object)path);
        return new Command("DOM.pushNodeByPathToFrontend", (Map)params.build(), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> pushNodesByBackendIdsToFrontend(List<BackendNodeId> backendNodeIds) {
        Objects.requireNonNull(backendNodeIds, "backendNodeIds is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"backendNodeIds", backendNodeIds);
        return new Command("DOM.pushNodesByBackendIdsToFrontend", (Map)params.build(), ConverterFunctions.map((String)"nodeIds", (Type)new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<NodeId> querySelector(NodeId nodeId, String selector) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"selector", (Object)selector);
        return new Command("DOM.querySelector", (Map)params.build(), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Command<List<NodeId>> querySelectorAll(NodeId nodeId, String selector) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"selector", (Object)selector);
        return new Command("DOM.querySelectorAll", (Map)params.build(), ConverterFunctions.map((String)"nodeIds", (Type)new TypeToken<List<NodeId>>(){}.getType()));
    }

    @Beta
    public static Command<Void> redo() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOM.redo", (Map)params.build());
    }

    public static Command<Void> removeAttribute(NodeId nodeId, String name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"name", (Object)name);
        return new Command("DOM.removeAttribute", (Map)params.build());
    }

    public static Command<Void> removeNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("DOM.removeNode", (Map)params.build());
    }

    public static Command<Void> requestChildNodes(NodeId nodeId, Optional<Integer> depth, Optional<Boolean> pierce) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command("DOM.requestChildNodes", (Map)params.build());
    }

    public static Command<NodeId> requestNode(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        return new Command("DOM.requestNode", (Map)params.build(), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Command<RemoteObject> resolveNode(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<String> objectGroup, Optional<ExecutionContextId> executionContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectGroup.ifPresent(p -> params.put((Object)"objectGroup", p));
        executionContextId.ifPresent(p -> params.put((Object)"executionContextId", p));
        return new Command("DOM.resolveNode", (Map)params.build(), ConverterFunctions.map((String)"object", RemoteObject.class));
    }

    public static Command<Void> setAttributeValue(NodeId nodeId, String name, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"name", (Object)name);
        params.put((Object)"value", (Object)value);
        return new Command("DOM.setAttributeValue", (Map)params.build());
    }

    public static Command<Void> setAttributesAsText(NodeId nodeId, String text, Optional<String> name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"text", (Object)text);
        name.ifPresent(p -> params.put((Object)"name", p));
        return new Command("DOM.setAttributesAsText", (Map)params.build());
    }

    public static Command<Void> setFileInputFiles(List<String> files, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        Objects.requireNonNull(files, "files is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"files", files);
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        return new Command("DOM.setFileInputFiles", (Map)params.build());
    }

    @Beta
    public static Command<Void> setNodeStackTracesEnabled(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"enable", (Object)enable);
        return new Command("DOM.setNodeStackTracesEnabled", (Map)params.build());
    }

    @Beta
    public static Command<StackTrace> getNodeStackTraces(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("DOM.getNodeStackTraces", (Map)params.build(), ConverterFunctions.map((String)"creation", StackTrace.class));
    }

    @Beta
    public static Command<String> getFileInfo(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        return new Command("DOM.getFileInfo", (Map)params.build(), ConverterFunctions.map((String)"path", String.class));
    }

    @Beta
    public static Command<Void> setInspectedNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        return new Command("DOM.setInspectedNode", (Map)params.build());
    }

    public static Command<NodeId> setNodeName(NodeId nodeId, String name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"name", (Object)name);
        return new Command("DOM.setNodeName", (Map)params.build(), ConverterFunctions.map((String)"nodeId", NodeId.class));
    }

    public static Command<Void> setNodeValue(NodeId nodeId, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"value", (Object)value);
        return new Command("DOM.setNodeValue", (Map)params.build());
    }

    public static Command<Void> setOuterHTML(NodeId nodeId, String outerHTML) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(outerHTML, "outerHTML is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"outerHTML", (Object)outerHTML);
        return new Command("DOM.setOuterHTML", (Map)params.build());
    }

    @Beta
    public static Command<Void> undo() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("DOM.undo", (Map)params.build());
    }

    @Beta
    public static Command<GetFrameOwnerResponse> getFrameOwner(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        return new Command("DOM.getFrameOwner", (Map)params.build(), input -> (GetFrameOwnerResponse)input.read(GetFrameOwnerResponse.class));
    }

    public static Event<AttributeModified> attributeModified() {
        return new Event("DOM.attributeModified", input -> (AttributeModified)input.read(AttributeModified.class));
    }

    public static Event<AttributeRemoved> attributeRemoved() {
        return new Event("DOM.attributeRemoved", input -> (AttributeRemoved)input.read(AttributeRemoved.class));
    }

    public static Event<CharacterDataModified> characterDataModified() {
        return new Event("DOM.characterDataModified", input -> (CharacterDataModified)input.read(CharacterDataModified.class));
    }

    public static Event<ChildNodeCountUpdated> childNodeCountUpdated() {
        return new Event("DOM.childNodeCountUpdated", input -> (ChildNodeCountUpdated)input.read(ChildNodeCountUpdated.class));
    }

    public static Event<ChildNodeInserted> childNodeInserted() {
        return new Event("DOM.childNodeInserted", input -> (ChildNodeInserted)input.read(ChildNodeInserted.class));
    }

    public static Event<ChildNodeRemoved> childNodeRemoved() {
        return new Event("DOM.childNodeRemoved", input -> (ChildNodeRemoved)input.read(ChildNodeRemoved.class));
    }

    public static Event<DistributedNodesUpdated> distributedNodesUpdated() {
        return new Event("DOM.distributedNodesUpdated", input -> (DistributedNodesUpdated)input.read(DistributedNodesUpdated.class));
    }

    public static Event<Void> documentUpdated() {
        return new Event("DOM.documentUpdated", input -> null);
    }

    public static Event<List<NodeId>> inlineStyleInvalidated() {
        return new Event("DOM.inlineStyleInvalidated", ConverterFunctions.map((String)"nodeIds", (Type)new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Event<PseudoElementAdded> pseudoElementAdded() {
        return new Event("DOM.pseudoElementAdded", input -> (PseudoElementAdded)input.read(PseudoElementAdded.class));
    }

    public static Event<PseudoElementRemoved> pseudoElementRemoved() {
        return new Event("DOM.pseudoElementRemoved", input -> (PseudoElementRemoved)input.read(PseudoElementRemoved.class));
    }

    public static Event<SetChildNodes> setChildNodes() {
        return new Event("DOM.setChildNodes", input -> (SetChildNodes)input.read(SetChildNodes.class));
    }

    public static Event<ShadowRootPopped> shadowRootPopped() {
        return new Event("DOM.shadowRootPopped", input -> (ShadowRootPopped)input.read(ShadowRootPopped.class));
    }

    public static Event<ShadowRootPushed> shadowRootPushed() {
        return new Event("DOM.shadowRootPushed", input -> (ShadowRootPushed)input.read(ShadowRootPushed.class));
    }

    public static class GetFrameOwnerResponse {
        private final BackendNodeId backendNodeId;
        private final Optional<NodeId> nodeId;

        public GetFrameOwnerResponse(BackendNodeId backendNodeId, Optional<NodeId> nodeId) {
            this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
            this.nodeId = nodeId;
        }

        public BackendNodeId getBackendNodeId() {
            return this.backendNodeId;
        }

        public Optional<NodeId> getNodeId() {
            return this.nodeId;
        }

        private static GetFrameOwnerResponse fromJson(JsonInput input) {
            BackendNodeId backendNodeId = null;
            Optional<NodeId> nodeId = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backendNodeId": {
                        backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                        continue block8;
                    }
                    case "nodeId": {
                        nodeId = Optional.ofNullable((NodeId)input.read(NodeId.class));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetFrameOwnerResponse(backendNodeId, nodeId);
        }
    }

    public static class PerformSearchResponse {
        private final String searchId;
        private final Integer resultCount;

        public PerformSearchResponse(String searchId, Integer resultCount) {
            this.searchId = Objects.requireNonNull(searchId, "searchId is required");
            this.resultCount = Objects.requireNonNull(resultCount, "resultCount is required");
        }

        public String getSearchId() {
            return this.searchId;
        }

        public Integer getResultCount() {
            return this.resultCount;
        }

        private static PerformSearchResponse fromJson(JsonInput input) {
            String searchId = null;
            Integer resultCount = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "searchId": {
                        searchId = input.nextString();
                        continue block8;
                    }
                    case "resultCount": {
                        resultCount = input.nextNumber().intValue();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new PerformSearchResponse(searchId, resultCount);
        }
    }

    public static class GetNodeForLocationResponse {
        private final BackendNodeId backendNodeId;
        private final FrameId frameId;
        private final Optional<NodeId> nodeId;

        public GetNodeForLocationResponse(BackendNodeId backendNodeId, FrameId frameId, Optional<NodeId> nodeId) {
            this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
            this.frameId = Objects.requireNonNull(frameId, "frameId is required");
            this.nodeId = nodeId;
        }

        public BackendNodeId getBackendNodeId() {
            return this.backendNodeId;
        }

        public FrameId getFrameId() {
            return this.frameId;
        }

        public Optional<NodeId> getNodeId() {
            return this.nodeId;
        }

        private static GetNodeForLocationResponse fromJson(JsonInput input) {
            BackendNodeId backendNodeId = null;
            FrameId frameId = null;
            Optional<NodeId> nodeId = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backendNodeId": {
                        backendNodeId = (BackendNodeId)input.read(BackendNodeId.class);
                        continue block10;
                    }
                    case "frameId": {
                        frameId = (FrameId)input.read(FrameId.class);
                        continue block10;
                    }
                    case "nodeId": {
                        nodeId = Optional.ofNullable((NodeId)input.read(NodeId.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetNodeForLocationResponse(backendNodeId, frameId, nodeId);
        }
    }
}

