package org.openqa.selenium.devtools.v87.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class SourceCodeLocation {

    private final java.lang.String url;

    private final java.lang.Integer lineNumber;

    private final java.lang.Integer columnNumber;

    public SourceCodeLocation(java.lang.String url, java.lang.Integer lineNumber, java.lang.Integer columnNumber) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.lineNumber = java.util.Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = java.util.Objects.requireNonNull(columnNumber, "columnNumber is required");
    }

    public java.lang.String getUrl() {
        return url;
    }

    public java.lang.Integer getLineNumber() {
        return lineNumber;
    }

    public java.lang.Integer getColumnNumber() {
        return columnNumber;
    }

    private static SourceCodeLocation fromJson(JsonInput input) {
        java.lang.String url = null;
        java.lang.Integer lineNumber = 0;
        java.lang.Integer columnNumber = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "lineNumber":
                    lineNumber = input.nextNumber().intValue();
                    break;
                case "columnNumber":
                    columnNumber = input.nextNumber().intValue();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SourceCodeLocation(url, lineNumber, columnNumber);
    }
}
