package org.openqa.selenium.devtools.v84.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * An inspector issue reported from the back-end.
 */
public class InspectorIssue {

    private final org.openqa.selenium.devtools.v84.audits.model.InspectorIssueCode code;

    private final org.openqa.selenium.devtools.v84.audits.model.InspectorIssueDetails details;

    public InspectorIssue(org.openqa.selenium.devtools.v84.audits.model.InspectorIssueCode code, org.openqa.selenium.devtools.v84.audits.model.InspectorIssueDetails details) {
        this.code = java.util.Objects.requireNonNull(code, "code is required");
        this.details = java.util.Objects.requireNonNull(details, "details is required");
    }

    public org.openqa.selenium.devtools.v84.audits.model.InspectorIssueCode getCode() {
        return code;
    }

    public org.openqa.selenium.devtools.v84.audits.model.InspectorIssueDetails getDetails() {
        return details;
    }

    private static InspectorIssue fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v84.audits.model.InspectorIssueCode code = null;
        org.openqa.selenium.devtools.v84.audits.model.InspectorIssueDetails details = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "code":
                    code = input.read(org.openqa.selenium.devtools.v84.audits.model.InspectorIssueCode.class);
                    break;
                case "details":
                    details = input.read(org.openqa.selenium.devtools.v84.audits.model.InspectorIssueDetails.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new InspectorIssue(code, details);
    }
}
