/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.network.model;

import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v144.network.model.DirectSocketDnsQueryType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectUDPSocketOptions {
    private final Optional<String> remoteAddr;
    private final Optional<Integer> remotePort;
    private final Optional<String> localAddr;
    private final Optional<Integer> localPort;
    private final Optional<DirectSocketDnsQueryType> dnsQueryType;
    private final Optional<Number> sendBufferSize;
    private final Optional<Number> receiveBufferSize;
    private final Optional<Boolean> multicastLoopback;
    private final Optional<Integer> multicastTimeToLive;
    private final Optional<Boolean> multicastAllowAddressSharing;

    public DirectUDPSocketOptions(Optional<String> remoteAddr, Optional<Integer> remotePort, Optional<String> localAddr, Optional<Integer> localPort, Optional<DirectSocketDnsQueryType> dnsQueryType, Optional<Number> sendBufferSize, Optional<Number> receiveBufferSize, Optional<Boolean> multicastLoopback, Optional<Integer> multicastTimeToLive, Optional<Boolean> multicastAllowAddressSharing) {
        this.remoteAddr = remoteAddr;
        this.remotePort = remotePort;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.dnsQueryType = dnsQueryType;
        this.sendBufferSize = sendBufferSize;
        this.receiveBufferSize = receiveBufferSize;
        this.multicastLoopback = multicastLoopback;
        this.multicastTimeToLive = multicastTimeToLive;
        this.multicastAllowAddressSharing = multicastAllowAddressSharing;
    }

    public Optional<String> getRemoteAddr() {
        return this.remoteAddr;
    }

    public Optional<Integer> getRemotePort() {
        return this.remotePort;
    }

    public Optional<String> getLocalAddr() {
        return this.localAddr;
    }

    public Optional<Integer> getLocalPort() {
        return this.localPort;
    }

    public Optional<DirectSocketDnsQueryType> getDnsQueryType() {
        return this.dnsQueryType;
    }

    public Optional<Number> getSendBufferSize() {
        return this.sendBufferSize;
    }

    public Optional<Number> getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public Optional<Boolean> getMulticastLoopback() {
        return this.multicastLoopback;
    }

    public Optional<Integer> getMulticastTimeToLive() {
        return this.multicastTimeToLive;
    }

    public Optional<Boolean> getMulticastAllowAddressSharing() {
        return this.multicastAllowAddressSharing;
    }

    private static DirectUDPSocketOptions fromJson(JsonInput input) {
        Optional<String> remoteAddr = Optional.empty();
        Optional<Integer> remotePort = Optional.empty();
        Optional<String> localAddr = Optional.empty();
        Optional<Integer> localPort = Optional.empty();
        Optional<DirectSocketDnsQueryType> dnsQueryType = Optional.empty();
        Optional<Number> sendBufferSize = Optional.empty();
        Optional<Number> receiveBufferSize = Optional.empty();
        Optional<Boolean> multicastLoopback = Optional.empty();
        Optional<Integer> multicastTimeToLive = Optional.empty();
        Optional<Boolean> multicastAllowAddressSharing = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "remoteAddr": {
                    remoteAddr = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "remotePort": {
                    remotePort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block24;
                }
                case "localAddr": {
                    localAddr = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "localPort": {
                    localPort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block24;
                }
                case "dnsQueryType": {
                    dnsQueryType = Optional.ofNullable((DirectSocketDnsQueryType)((Object)input.read(DirectSocketDnsQueryType.class)));
                    continue block24;
                }
                case "sendBufferSize": {
                    sendBufferSize = Optional.ofNullable(input.nextNumber());
                    continue block24;
                }
                case "receiveBufferSize": {
                    receiveBufferSize = Optional.ofNullable(input.nextNumber());
                    continue block24;
                }
                case "multicastLoopback": {
                    multicastLoopback = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "multicastTimeToLive": {
                    multicastTimeToLive = Optional.ofNullable(input.nextNumber().intValue());
                    continue block24;
                }
                case "multicastAllowAddressSharing": {
                    multicastAllowAddressSharing = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectUDPSocketOptions(remoteAddr, remotePort, localAddr, localPort, dnsQueryType, sendBufferSize, receiveBufferSize, multicastLoopback, multicastTimeToLive, multicastAllowAddressSharing);
    }
}

