/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.network.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class CookiePartitionKey {
    private final String topLevelSite;
    private final Boolean hasCrossSiteAncestor;

    public CookiePartitionKey(String topLevelSite, Boolean hasCrossSiteAncestor) {
        this.topLevelSite = Objects.requireNonNull(topLevelSite, "topLevelSite is required");
        this.hasCrossSiteAncestor = Objects.requireNonNull(hasCrossSiteAncestor, "hasCrossSiteAncestor is required");
    }

    public String getTopLevelSite() {
        return this.topLevelSite;
    }

    public Boolean getHasCrossSiteAncestor() {
        return this.hasCrossSiteAncestor;
    }

    private static CookiePartitionKey fromJson(JsonInput input) {
        String topLevelSite = null;
        Boolean hasCrossSiteAncestor = false;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "topLevelSite": {
                    topLevelSite = input.nextString();
                    continue block8;
                }
                case "hasCrossSiteAncestor": {
                    hasCrossSiteAncestor = input.nextBoolean();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CookiePartitionKey(topLevelSite, hasCrossSiteAncestor);
    }
}

