/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v144.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum SRIMessageSignatureError {
    MISSINGSIGNATUREHEADER("MissingSignatureHeader"),
    MISSINGSIGNATUREINPUTHEADER("MissingSignatureInputHeader"),
    INVALIDSIGNATUREHEADER("InvalidSignatureHeader"),
    INVALIDSIGNATUREINPUTHEADER("InvalidSignatureInputHeader"),
    SIGNATUREHEADERVALUEISNOTBYTESEQUENCE("SignatureHeaderValueIsNotByteSequence"),
    SIGNATUREHEADERVALUEISPARAMETERIZED("SignatureHeaderValueIsParameterized"),
    SIGNATUREHEADERVALUEISINCORRECTLENGTH("SignatureHeaderValueIsIncorrectLength"),
    SIGNATUREINPUTHEADERMISSINGLABEL("SignatureInputHeaderMissingLabel"),
    SIGNATUREINPUTHEADERVALUENOTINNERLIST("SignatureInputHeaderValueNotInnerList"),
    SIGNATUREINPUTHEADERVALUEMISSINGCOMPONENTS("SignatureInputHeaderValueMissingComponents"),
    SIGNATUREINPUTHEADERINVALIDCOMPONENTTYPE("SignatureInputHeaderInvalidComponentType"),
    SIGNATUREINPUTHEADERINVALIDCOMPONENTNAME("SignatureInputHeaderInvalidComponentName"),
    SIGNATUREINPUTHEADERINVALIDHEADERCOMPONENTPARAMETER("SignatureInputHeaderInvalidHeaderComponentParameter"),
    SIGNATUREINPUTHEADERINVALIDDERIVEDCOMPONENTPARAMETER("SignatureInputHeaderInvalidDerivedComponentParameter"),
    SIGNATUREINPUTHEADERKEYIDLENGTH("SignatureInputHeaderKeyIdLength"),
    SIGNATUREINPUTHEADERINVALIDPARAMETER("SignatureInputHeaderInvalidParameter"),
    SIGNATUREINPUTHEADERMISSINGREQUIREDPARAMETERS("SignatureInputHeaderMissingRequiredParameters"),
    VALIDATIONFAILEDSIGNATUREEXPIRED("ValidationFailedSignatureExpired"),
    VALIDATIONFAILEDINVALIDLENGTH("ValidationFailedInvalidLength"),
    VALIDATIONFAILEDSIGNATUREMISMATCH("ValidationFailedSignatureMismatch"),
    VALIDATIONFAILEDINTEGRITYMISMATCH("ValidationFailedIntegrityMismatch");

    private String value;

    private SRIMessageSignatureError(String value) {
        this.value = value;
    }

    public static SRIMessageSignatureError fromString(String s) {
        return Arrays.stream(SRIMessageSignatureError.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SRIMessageSignatureError "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static SRIMessageSignatureError fromJson(JsonInput input) {
        return SRIMessageSignatureError.fromString(input.nextString());
    }
}

