/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.page.model;

import java.util.Arrays;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v142.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class FrameDetached {
    private final FrameId frameId;
    private final Reason reason;

    public FrameDetached(FrameId frameId, Reason reason) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.reason = Objects.requireNonNull(reason, "reason is required");
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    @Beta
    public Reason getReason() {
        return this.reason;
    }

    private static FrameDetached fromJson(JsonInput input) {
        FrameId frameId = null;
        Reason reason = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block8;
                }
                case "reason": {
                    reason = Reason.fromString(input.nextString());
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameDetached(frameId, reason);
    }

    public static enum Reason {
        REMOVE("remove"),
        SWAP("swap");

        private String value;

        private Reason(String value) {
            this.value = value;
        }

        public static Reason fromString(String s) {
            return Arrays.stream(Reason.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Reason "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Reason fromJson(JsonInput input) {
            return Reason.fromString(input.nextString());
        }
    }
}

