/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.page.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v142.page.model.FileFilter;
import org.openqa.selenium.devtools.v142.page.model.ImageResource;
import org.openqa.selenium.json.JsonInput;

@Beta
public class FileHandler {
    private final String action;
    private final String name;
    private final Optional<List<ImageResource>> icons;
    private final Optional<List<FileFilter>> accepts;
    private final String launchType;

    public FileHandler(String action, String name, Optional<List<ImageResource>> icons, Optional<List<FileFilter>> accepts, String launchType) {
        this.action = Objects.requireNonNull(action, "action is required");
        this.name = Objects.requireNonNull(name, "name is required");
        this.icons = icons;
        this.accepts = accepts;
        this.launchType = Objects.requireNonNull(launchType, "launchType is required");
    }

    public String getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    public Optional<List<ImageResource>> getIcons() {
        return this.icons;
    }

    public Optional<List<FileFilter>> getAccepts() {
        return this.accepts;
    }

    public String getLaunchType() {
        return this.launchType;
    }

    private static FileHandler fromJson(JsonInput input) {
        String action = null;
        String name = null;
        Optional<List<ImageResource>> icons = Optional.empty();
        Optional<List<FileFilter>> accepts = Optional.empty();
        String launchType = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "action": {
                    action = input.nextString();
                    continue block14;
                }
                case "name": {
                    name = input.nextString();
                    continue block14;
                }
                case "icons": {
                    icons = Optional.ofNullable(input.readArray(ImageResource.class));
                    continue block14;
                }
                case "accepts": {
                    accepts = Optional.ofNullable(input.readArray(FileFilter.class));
                    continue block14;
                }
                case "launchType": {
                    launchType = input.nextString();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FileHandler(action, name, icons, accepts, launchType);
    }
}

