/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DirectUDPMessage {
    private final String data;
    private final Optional<String> remoteAddr;
    private final Optional<Integer> remotePort;

    public DirectUDPMessage(String data, Optional<String> remoteAddr, Optional<Integer> remotePort) {
        this.data = Objects.requireNonNull(data, "data is required");
        this.remoteAddr = remoteAddr;
        this.remotePort = remotePort;
    }

    public String getData() {
        return this.data;
    }

    public Optional<String> getRemoteAddr() {
        return this.remoteAddr;
    }

    public Optional<Integer> getRemotePort() {
        return this.remotePort;
    }

    private static DirectUDPMessage fromJson(JsonInput input) {
        String data = null;
        Optional<String> remoteAddr = Optional.empty();
        Optional<Integer> remotePort = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "data": {
                    data = input.nextString();
                    continue block10;
                }
                case "remoteAddr": {
                    remoteAddr = Optional.ofNullable(input.nextString());
                    continue block10;
                }
                case "remotePort": {
                    remotePort = Optional.ofNullable(input.nextNumber().intValue());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DirectUDPMessage(data, remoteAddr, remotePort);
    }
}

