/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.storage.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum StorageType {
    COOKIES("cookies"),
    FILE_SYSTEMS("file_systems"),
    INDEXEDDB("indexeddb"),
    LOCAL_STORAGE("local_storage"),
    SHADER_CACHE("shader_cache"),
    WEBSQL("websql"),
    SERVICE_WORKERS("service_workers"),
    CACHE_STORAGE("cache_storage"),
    INTEREST_GROUPS("interest_groups"),
    SHARED_STORAGE("shared_storage"),
    STORAGE_BUCKETS("storage_buckets"),
    ALL("all"),
    OTHER("other");

    private String value;

    private StorageType(String value) {
        this.value = value;
    }

    public static StorageType fromString(String s) {
        return Arrays.stream(StorageType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within StorageType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static StorageType fromJson(JsonInput input) {
        return StorageType.fromString(input.nextString());
    }
}

