/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v137.storage.model;

import java.util.List;
import java.util.Optional;
import org.openqa.selenium.devtools.v137.storage.model.SharedStoragePrivateAggregationConfig;
import org.openqa.selenium.devtools.v137.storage.model.SharedStorageUrlWithMetadata;
import org.openqa.selenium.json.JsonInput;

public class SharedStorageAccessParams {
    private final Optional<String> scriptSourceUrl;
    private final Optional<String> dataOrigin;
    private final Optional<String> operationName;
    private final Optional<Boolean> keepAlive;
    private final Optional<SharedStoragePrivateAggregationConfig> privateAggregationConfig;
    private final Optional<String> serializedData;
    private final Optional<List<SharedStorageUrlWithMetadata>> urlsWithMetadata;
    private final Optional<String> urnUuid;
    private final Optional<String> key;
    private final Optional<String> value;
    private final Optional<Boolean> ignoreIfPresent;
    private final Optional<String> workletId;
    private final Optional<String> withLock;
    private final Optional<String> batchUpdateId;
    private final Optional<Integer> batchSize;

    public SharedStorageAccessParams(Optional<String> scriptSourceUrl, Optional<String> dataOrigin, Optional<String> operationName, Optional<Boolean> keepAlive, Optional<SharedStoragePrivateAggregationConfig> privateAggregationConfig, Optional<String> serializedData, Optional<List<SharedStorageUrlWithMetadata>> urlsWithMetadata, Optional<String> urnUuid, Optional<String> key, Optional<String> value, Optional<Boolean> ignoreIfPresent, Optional<String> workletId, Optional<String> withLock, Optional<String> batchUpdateId, Optional<Integer> batchSize) {
        this.scriptSourceUrl = scriptSourceUrl;
        this.dataOrigin = dataOrigin;
        this.operationName = operationName;
        this.keepAlive = keepAlive;
        this.privateAggregationConfig = privateAggregationConfig;
        this.serializedData = serializedData;
        this.urlsWithMetadata = urlsWithMetadata;
        this.urnUuid = urnUuid;
        this.key = key;
        this.value = value;
        this.ignoreIfPresent = ignoreIfPresent;
        this.workletId = workletId;
        this.withLock = withLock;
        this.batchUpdateId = batchUpdateId;
        this.batchSize = batchSize;
    }

    public Optional<String> getScriptSourceUrl() {
        return this.scriptSourceUrl;
    }

    public Optional<String> getDataOrigin() {
        return this.dataOrigin;
    }

    public Optional<String> getOperationName() {
        return this.operationName;
    }

    public Optional<Boolean> getKeepAlive() {
        return this.keepAlive;
    }

    public Optional<SharedStoragePrivateAggregationConfig> getPrivateAggregationConfig() {
        return this.privateAggregationConfig;
    }

    public Optional<String> getSerializedData() {
        return this.serializedData;
    }

    public Optional<List<SharedStorageUrlWithMetadata>> getUrlsWithMetadata() {
        return this.urlsWithMetadata;
    }

    public Optional<String> getUrnUuid() {
        return this.urnUuid;
    }

    public Optional<String> getKey() {
        return this.key;
    }

    public Optional<String> getValue() {
        return this.value;
    }

    public Optional<Boolean> getIgnoreIfPresent() {
        return this.ignoreIfPresent;
    }

    public Optional<String> getWorkletId() {
        return this.workletId;
    }

    public Optional<String> getWithLock() {
        return this.withLock;
    }

    public Optional<String> getBatchUpdateId() {
        return this.batchUpdateId;
    }

    public Optional<Integer> getBatchSize() {
        return this.batchSize;
    }

    private static SharedStorageAccessParams fromJson(JsonInput input) {
        Optional<String> scriptSourceUrl = Optional.empty();
        Optional<String> dataOrigin = Optional.empty();
        Optional<String> operationName = Optional.empty();
        Optional<Boolean> keepAlive = Optional.empty();
        Optional<SharedStoragePrivateAggregationConfig> privateAggregationConfig = Optional.empty();
        Optional<String> serializedData = Optional.empty();
        Optional<List<SharedStorageUrlWithMetadata>> urlsWithMetadata = Optional.empty();
        Optional<String> urnUuid = Optional.empty();
        Optional<String> key = Optional.empty();
        Optional<String> value = Optional.empty();
        Optional<Boolean> ignoreIfPresent = Optional.empty();
        Optional<String> workletId = Optional.empty();
        Optional<String> withLock = Optional.empty();
        Optional<String> batchUpdateId = Optional.empty();
        Optional<Integer> batchSize = Optional.empty();
        input.beginObject();
        block34: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptSourceUrl": {
                    scriptSourceUrl = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "dataOrigin": {
                    dataOrigin = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "operationName": {
                    operationName = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "keepAlive": {
                    keepAlive = Optional.ofNullable(input.nextBoolean());
                    continue block34;
                }
                case "privateAggregationConfig": {
                    privateAggregationConfig = Optional.ofNullable((SharedStoragePrivateAggregationConfig)input.read(SharedStoragePrivateAggregationConfig.class));
                    continue block34;
                }
                case "serializedData": {
                    serializedData = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "urlsWithMetadata": {
                    urlsWithMetadata = Optional.ofNullable(input.readArray(SharedStorageUrlWithMetadata.class));
                    continue block34;
                }
                case "urnUuid": {
                    urnUuid = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "key": {
                    key = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "value": {
                    value = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "ignoreIfPresent": {
                    ignoreIfPresent = Optional.ofNullable(input.nextBoolean());
                    continue block34;
                }
                case "workletId": {
                    workletId = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "withLock": {
                    withLock = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "batchUpdateId": {
                    batchUpdateId = Optional.ofNullable(input.nextString());
                    continue block34;
                }
                case "batchSize": {
                    batchSize = Optional.ofNullable(input.nextNumber().intValue());
                    continue block34;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SharedStorageAccessParams(scriptSourceUrl, dataOrigin, operationName, keepAlive, privateAggregationConfig, serializedData, urlsWithMetadata, urnUuid, key, value, ignoreIfPresent, workletId, withLock, batchUpdateId, batchSize);
    }
}

