package org.openqa.selenium.devtools.v136.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class PartitioningBlobURLIssueDetails {

    private final java.lang.String url;

    private final org.openqa.selenium.devtools.v136.audits.model.PartitioningBlobURLInfo partitioningBlobURLInfo;

    public PartitioningBlobURLIssueDetails(java.lang.String url, org.openqa.selenium.devtools.v136.audits.model.PartitioningBlobURLInfo partitioningBlobURLInfo) {
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.partitioningBlobURLInfo = java.util.Objects.requireNonNull(partitioningBlobURLInfo, "partitioningBlobURLInfo is required");
    }

    /**
     * The BlobURL that failed to load.
     */
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Additional information about the Partitioning Blob URL issue.
     */
    public org.openqa.selenium.devtools.v136.audits.model.PartitioningBlobURLInfo getPartitioningBlobURLInfo() {
        return partitioningBlobURLInfo;
    }

    private static PartitioningBlobURLIssueDetails fromJson(JsonInput input) {
        java.lang.String url = null;
        org.openqa.selenium.devtools.v136.audits.model.PartitioningBlobURLInfo partitioningBlobURLInfo = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "url":
                    url = input.nextString();
                    break;
                case "partitioningBlobURLInfo":
                    partitioningBlobURLInfo = input.read(org.openqa.selenium.devtools.v136.audits.model.PartitioningBlobURLInfo.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PartitioningBlobURLIssueDetails(url, partitioningBlobURLInfo);
    }
}
