package org.openqa.selenium.devtools.v136.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum CrossOriginOpenerPolicyValue {

    SAMEORIGIN("SameOrigin"),
    SAMEORIGINALLOWPOPUPS("SameOriginAllowPopups"),
    RESTRICTPROPERTIES("RestrictProperties"),
    UNSAFENONE("UnsafeNone"),
    SAMEORIGINPLUSCOEP("SameOriginPlusCoep"),
    RESTRICTPROPERTIESPLUSCOEP("RestrictPropertiesPlusCoep"),
    NOOPENERALLOWPOPUPS("NoopenerAllowPopups");

    private String value;

    CrossOriginOpenerPolicyValue(String value) {
        this.value = value;
    }

    public static CrossOriginOpenerPolicyValue fromString(String s) {
        return java.util.Arrays.stream(CrossOriginOpenerPolicyValue.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CrossOriginOpenerPolicyValue "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CrossOriginOpenerPolicyValue fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
