/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v135.domsnapshot.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v135.dom.model.Rect;
import org.openqa.selenium.devtools.v135.domsnapshot.model.InlineTextBox;
import org.openqa.selenium.json.JsonInput;

public class LayoutTreeNode {
    private final Integer domNodeIndex;
    private final Rect boundingBox;
    private final Optional<String> layoutText;
    private final Optional<List<InlineTextBox>> inlineTextNodes;
    private final Optional<Integer> styleIndex;
    private final Optional<Integer> paintOrder;
    private final Optional<Boolean> isStackingContext;

    public LayoutTreeNode(Integer domNodeIndex, Rect boundingBox, Optional<String> layoutText, Optional<List<InlineTextBox>> inlineTextNodes, Optional<Integer> styleIndex, Optional<Integer> paintOrder, Optional<Boolean> isStackingContext) {
        this.domNodeIndex = Objects.requireNonNull(domNodeIndex, "domNodeIndex is required");
        this.boundingBox = Objects.requireNonNull(boundingBox, "boundingBox is required");
        this.layoutText = layoutText;
        this.inlineTextNodes = inlineTextNodes;
        this.styleIndex = styleIndex;
        this.paintOrder = paintOrder;
        this.isStackingContext = isStackingContext;
    }

    public Integer getDomNodeIndex() {
        return this.domNodeIndex;
    }

    public Rect getBoundingBox() {
        return this.boundingBox;
    }

    public Optional<String> getLayoutText() {
        return this.layoutText;
    }

    public Optional<List<InlineTextBox>> getInlineTextNodes() {
        return this.inlineTextNodes;
    }

    public Optional<Integer> getStyleIndex() {
        return this.styleIndex;
    }

    public Optional<Integer> getPaintOrder() {
        return this.paintOrder;
    }

    public Optional<Boolean> getIsStackingContext() {
        return this.isStackingContext;
    }

    private static LayoutTreeNode fromJson(JsonInput input) {
        Integer domNodeIndex = 0;
        Rect boundingBox = null;
        Optional<String> layoutText = Optional.empty();
        Optional<List<InlineTextBox>> inlineTextNodes = Optional.empty();
        Optional<Integer> styleIndex = Optional.empty();
        Optional<Integer> paintOrder = Optional.empty();
        Optional<Boolean> isStackingContext = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "domNodeIndex": {
                    domNodeIndex = input.nextNumber().intValue();
                    continue block18;
                }
                case "boundingBox": {
                    boundingBox = (Rect)input.read(Rect.class);
                    continue block18;
                }
                case "layoutText": {
                    layoutText = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "inlineTextNodes": {
                    inlineTextNodes = Optional.ofNullable(input.readArray(InlineTextBox.class));
                    continue block18;
                }
                case "styleIndex": {
                    styleIndex = Optional.ofNullable(input.nextNumber().intValue());
                    continue block18;
                }
                case "paintOrder": {
                    paintOrder = Optional.ofNullable(input.nextNumber().intValue());
                    continue block18;
                }
                case "isStackingContext": {
                    isStackingContext = Optional.ofNullable(input.nextBoolean());
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LayoutTreeNode(domNodeIndex, boundingBox, layoutText, inlineTextNodes, styleIndex, paintOrder, isStackingContext);
    }
}

