package org.openqa.selenium.devtools.v135.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Information of headers to be displayed when the header mismatch occurred.
 */
public class PrerenderMismatchedHeaders {

    private final java.lang.String headerName;

    private final java.util.Optional<java.lang.String> initialValue;

    private final java.util.Optional<java.lang.String> activationValue;

    public PrerenderMismatchedHeaders(java.lang.String headerName, java.util.Optional<java.lang.String> initialValue, java.util.Optional<java.lang.String> activationValue) {
        this.headerName = java.util.Objects.requireNonNull(headerName, "headerName is required");
        this.initialValue = initialValue;
        this.activationValue = activationValue;
    }

    public java.lang.String getHeaderName() {
        return headerName;
    }

    public java.util.Optional<java.lang.String> getInitialValue() {
        return initialValue;
    }

    public java.util.Optional<java.lang.String> getActivationValue() {
        return activationValue;
    }

    private static PrerenderMismatchedHeaders fromJson(JsonInput input) {
        java.lang.String headerName = null;
        java.util.Optional<java.lang.String> initialValue = java.util.Optional.empty();
        java.util.Optional<java.lang.String> activationValue = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "headerName":
                    headerName = input.nextString();
                    break;
                case "initialValue":
                    initialValue = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "activationValue":
                    activationValue = java.util.Optional.ofNullable(input.nextString());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PrerenderMismatchedHeaders(headerName, initialValue, activationValue);
    }
}
