package org.openqa.selenium.devtools.v133.bluetoothemulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Stores the advertisement packet information that is sent by a Bluetooth device.
 */
public class ScanEntry {

    private final java.lang.String deviceAddress;

    private final java.lang.Integer rssi;

    private final org.openqa.selenium.devtools.v133.bluetoothemulation.model.ScanRecord scanRecord;

    public ScanEntry(java.lang.String deviceAddress, java.lang.Integer rssi, org.openqa.selenium.devtools.v133.bluetoothemulation.model.ScanRecord scanRecord) {
        this.deviceAddress = java.util.Objects.requireNonNull(deviceAddress, "deviceAddress is required");
        this.rssi = java.util.Objects.requireNonNull(rssi, "rssi is required");
        this.scanRecord = java.util.Objects.requireNonNull(scanRecord, "scanRecord is required");
    }

    public java.lang.String getDeviceAddress() {
        return deviceAddress;
    }

    public java.lang.Integer getRssi() {
        return rssi;
    }

    public org.openqa.selenium.devtools.v133.bluetoothemulation.model.ScanRecord getScanRecord() {
        return scanRecord;
    }

    private static ScanEntry fromJson(JsonInput input) {
        java.lang.String deviceAddress = null;
        java.lang.Integer rssi = 0;
        org.openqa.selenium.devtools.v133.bluetoothemulation.model.ScanRecord scanRecord = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "deviceAddress":
                    deviceAddress = input.nextString();
                    break;
                case "rssi":
                    rssi = input.nextNumber().intValue();
                    break;
                case "scanRecord":
                    scanRecord = input.read(org.openqa.selenium.devtools.v133.bluetoothemulation.model.ScanRecord.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ScanEntry(deviceAddress, rssi, scanRecord);
    }
}
