package org.openqa.selenium.devtools.v130.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when additional information about a responseReceived event is available from the network
 * stack. Not every responseReceived event will have an additional responseReceivedExtraInfo for
 * it, and responseReceivedExtraInfo may be fired before or after responseReceived.
 */
@org.openqa.selenium.Beta()
public class ResponseReceivedExtraInfo {

    private final org.openqa.selenium.devtools.v130.network.model.RequestId requestId;

    private final java.util.List<org.openqa.selenium.devtools.v130.network.model.BlockedSetCookieWithReason> blockedCookies;

    private final org.openqa.selenium.devtools.v130.network.model.Headers headers;

    private final org.openqa.selenium.devtools.v130.network.model.IPAddressSpace resourceIPAddressSpace;

    private final java.lang.Integer statusCode;

    private final java.util.Optional<java.lang.String> headersText;

    private final java.util.Optional<org.openqa.selenium.devtools.v130.network.model.CookiePartitionKey> cookiePartitionKey;

    private final java.util.Optional<java.lang.Boolean> cookiePartitionKeyOpaque;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.network.model.ExemptedSetCookieWithReason>> exemptedCookies;

    public ResponseReceivedExtraInfo(org.openqa.selenium.devtools.v130.network.model.RequestId requestId, java.util.List<org.openqa.selenium.devtools.v130.network.model.BlockedSetCookieWithReason> blockedCookies, org.openqa.selenium.devtools.v130.network.model.Headers headers, org.openqa.selenium.devtools.v130.network.model.IPAddressSpace resourceIPAddressSpace, java.lang.Integer statusCode, java.util.Optional<java.lang.String> headersText, java.util.Optional<org.openqa.selenium.devtools.v130.network.model.CookiePartitionKey> cookiePartitionKey, java.util.Optional<java.lang.Boolean> cookiePartitionKeyOpaque, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.network.model.ExemptedSetCookieWithReason>> exemptedCookies) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.blockedCookies = java.util.Objects.requireNonNull(blockedCookies, "blockedCookies is required");
        this.headers = java.util.Objects.requireNonNull(headers, "headers is required");
        this.resourceIPAddressSpace = java.util.Objects.requireNonNull(resourceIPAddressSpace, "resourceIPAddressSpace is required");
        this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
        this.headersText = headersText;
        this.cookiePartitionKey = cookiePartitionKey;
        this.cookiePartitionKeyOpaque = cookiePartitionKeyOpaque;
        this.exemptedCookies = exemptedCookies;
    }

    /**
     * Request identifier. Used to match this information to another responseReceived event.
     */
    public org.openqa.selenium.devtools.v130.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * A list of cookies which were not stored from the response along with the corresponding
     * reasons for blocking. The cookies here may not be valid due to syntax errors, which
     * are represented by the invalid cookie line string instead of a proper cookie.
     */
    public java.util.List<org.openqa.selenium.devtools.v130.network.model.BlockedSetCookieWithReason> getBlockedCookies() {
        return blockedCookies;
    }

    /**
     * Raw response headers as they were received over the wire.
     */
    public org.openqa.selenium.devtools.v130.network.model.Headers getHeaders() {
        return headers;
    }

    /**
     * The IP address space of the resource. The address space can only be determined once the transport
     * established the connection, so we can't send it in `requestWillBeSentExtraInfo`.
     */
    public org.openqa.selenium.devtools.v130.network.model.IPAddressSpace getResourceIPAddressSpace() {
        return resourceIPAddressSpace;
    }

    /**
     * The status code of the response. This is useful in cases the request failed and no responseReceived
     * event is triggered, which is the case for, e.g., CORS errors. This is also the correct status code
     * for cached requests, where the status in responseReceived is a 200 and this will be 304.
     */
    public java.lang.Integer getStatusCode() {
        return statusCode;
    }

    /**
     * Raw response header text as it was received over the wire. The raw text may not always be
     * available, such as in the case of HTTP/2 or QUIC.
     */
    public java.util.Optional<java.lang.String> getHeadersText() {
        return headersText;
    }

    /**
     * The cookie partition key that will be used to store partitioned cookies set in this response.
     * Only sent when partitioned cookies are enabled.
     */
    @Beta()
    public java.util.Optional<org.openqa.selenium.devtools.v130.network.model.CookiePartitionKey> getCookiePartitionKey() {
        return cookiePartitionKey;
    }

    /**
     * True if partitioned cookies are enabled, but the partition key is not serializable to string.
     */
    public java.util.Optional<java.lang.Boolean> getCookiePartitionKeyOpaque() {
        return cookiePartitionKeyOpaque;
    }

    /**
     * A list of cookies which should have been blocked by 3PCD but are exempted and stored from
     * the response with the corresponding reason.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.network.model.ExemptedSetCookieWithReason>> getExemptedCookies() {
        return exemptedCookies;
    }

    private static ResponseReceivedExtraInfo fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v130.network.model.RequestId requestId = null;
        java.util.List<org.openqa.selenium.devtools.v130.network.model.BlockedSetCookieWithReason> blockedCookies = null;
        org.openqa.selenium.devtools.v130.network.model.Headers headers = null;
        org.openqa.selenium.devtools.v130.network.model.IPAddressSpace resourceIPAddressSpace = null;
        java.lang.Integer statusCode = 0;
        java.util.Optional<java.lang.String> headersText = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v130.network.model.CookiePartitionKey> cookiePartitionKey = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> cookiePartitionKeyOpaque = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.network.model.ExemptedSetCookieWithReason>> exemptedCookies = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v130.network.model.RequestId.class);
                    break;
                case "blockedCookies":
                    blockedCookies = input.readArray(org.openqa.selenium.devtools.v130.network.model.BlockedSetCookieWithReason.class);
                    break;
                case "headers":
                    headers = input.read(org.openqa.selenium.devtools.v130.network.model.Headers.class);
                    break;
                case "resourceIPAddressSpace":
                    resourceIPAddressSpace = input.read(org.openqa.selenium.devtools.v130.network.model.IPAddressSpace.class);
                    break;
                case "statusCode":
                    statusCode = input.nextNumber().intValue();
                    break;
                case "headersText":
                    headersText = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "cookiePartitionKey":
                    cookiePartitionKey = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v130.network.model.CookiePartitionKey.class));
                    break;
                case "cookiePartitionKeyOpaque":
                    cookiePartitionKeyOpaque = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                case "exemptedCookies":
                    exemptedCookies = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v130.network.model.ExemptedSetCookieWithReason.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ResponseReceivedExtraInfo(requestId, blockedCookies, headers, resourceIPAddressSpace, statusCode, headersText, cookiePartitionKey, cookiePartitionKeyOpaque, exemptedCookies);
    }
}
