/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v130.network.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v130.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v130.network.model.RequestId;
import org.openqa.selenium.devtools.v130.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v130.network.model.WebSocketRequest;
import org.openqa.selenium.json.JsonInput;

public class WebSocketWillSendHandshakeRequest {
    private final RequestId requestId;
    private final MonotonicTime timestamp;
    private final TimeSinceEpoch wallTime;
    private final WebSocketRequest request;

    public WebSocketWillSendHandshakeRequest(RequestId requestId, MonotonicTime timestamp, TimeSinceEpoch wallTime, WebSocketRequest request) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is required");
        this.request = Objects.requireNonNull(request, "request is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public TimeSinceEpoch getWallTime() {
        return this.wallTime;
    }

    public WebSocketRequest getRequest() {
        return this.request;
    }

    private static WebSocketWillSendHandshakeRequest fromJson(JsonInput input) {
        RequestId requestId = null;
        MonotonicTime timestamp = null;
        TimeSinceEpoch wallTime = null;
        WebSocketRequest request = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block12;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block12;
                }
                case "wallTime": {
                    wallTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block12;
                }
                case "request": {
                    request = (WebSocketRequest)input.read(WebSocketRequest.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new WebSocketWillSendHandshakeRequest(requestId, timestamp, wallTime, request);
    }
}

