package org.openqa.selenium.devtools.v130.bluetoothemulation;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows configuring virtual Bluetooth devices to test
 * the web-bluetooth API.
 */
@Beta()
public class BluetoothEmulation {

    /**
     * Enable the BluetoothEmulation domain.
     */
    public static Command<Void> enable(org.openqa.selenium.devtools.v130.bluetoothemulation.model.CentralState state) {
        java.util.Objects.requireNonNull(state, "state is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("state", state);
        return new Command<>("BluetoothEmulation.enable", Map.copyOf(params));
    }

    /**
     * Disable the BluetoothEmulation domain.
     */
    public static Command<Void> disable() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("BluetoothEmulation.disable", Map.copyOf(params));
    }

    /**
     * Simulates a peripheral with |address|, |name| and |knownServiceUuids|
     * that has already been connected to the system.
     */
    public static Command<Void> simulatePreconnectedPeripheral(java.lang.String address, java.lang.String name, java.util.List<org.openqa.selenium.devtools.v130.bluetoothemulation.model.ManufacturerData> manufacturerData, java.util.List<java.lang.String> knownServiceUuids) {
        java.util.Objects.requireNonNull(address, "address is required");
        java.util.Objects.requireNonNull(name, "name is required");
        java.util.Objects.requireNonNull(manufacturerData, "manufacturerData is required");
        java.util.Objects.requireNonNull(knownServiceUuids, "knownServiceUuids is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("address", address);
        params.put("name", name);
        params.put("manufacturerData", manufacturerData);
        params.put("knownServiceUuids", knownServiceUuids);
        return new Command<>("BluetoothEmulation.simulatePreconnectedPeripheral", Map.copyOf(params));
    }

    /**
     * Simulates an advertisement packet described in |entry| being received by
     * the central.
     */
    public static Command<Void> simulateAdvertisement(org.openqa.selenium.devtools.v130.bluetoothemulation.model.ScanEntry entry) {
        java.util.Objects.requireNonNull(entry, "entry is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("entry", entry);
        return new Command<>("BluetoothEmulation.simulateAdvertisement", Map.copyOf(params));
    }
}
