/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v130.preload.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v130.preload.model.PreloadingAttemptKey;
import org.openqa.selenium.devtools.v130.preload.model.PreloadingStatus;
import org.openqa.selenium.devtools.v130.preload.model.PrerenderFinalStatus;
import org.openqa.selenium.devtools.v130.preload.model.PrerenderMismatchedHeaders;
import org.openqa.selenium.json.JsonInput;

public class PrerenderStatusUpdated {
    private final PreloadingAttemptKey key;
    private final PreloadingStatus status;
    private final Optional<PrerenderFinalStatus> prerenderStatus;
    private final Optional<String> disallowedMojoInterface;
    private final Optional<List<PrerenderMismatchedHeaders>> mismatchedHeaders;

    public PrerenderStatusUpdated(PreloadingAttemptKey key, PreloadingStatus status, Optional<PrerenderFinalStatus> prerenderStatus, Optional<String> disallowedMojoInterface, Optional<List<PrerenderMismatchedHeaders>> mismatchedHeaders) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.prerenderStatus = prerenderStatus;
        this.disallowedMojoInterface = disallowedMojoInterface;
        this.mismatchedHeaders = mismatchedHeaders;
    }

    public PreloadingAttemptKey getKey() {
        return this.key;
    }

    public PreloadingStatus getStatus() {
        return this.status;
    }

    public Optional<PrerenderFinalStatus> getPrerenderStatus() {
        return this.prerenderStatus;
    }

    public Optional<String> getDisallowedMojoInterface() {
        return this.disallowedMojoInterface;
    }

    public Optional<List<PrerenderMismatchedHeaders>> getMismatchedHeaders() {
        return this.mismatchedHeaders;
    }

    private static PrerenderStatusUpdated fromJson(JsonInput input) {
        PreloadingAttemptKey key = null;
        PreloadingStatus status = null;
        Optional<PrerenderFinalStatus> prerenderStatus = Optional.empty();
        Optional<String> disallowedMojoInterface = Optional.empty();
        Optional<List<PrerenderMismatchedHeaders>> mismatchedHeaders = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "key": {
                    key = (PreloadingAttemptKey)input.read(PreloadingAttemptKey.class);
                    continue block14;
                }
                case "status": {
                    status = (PreloadingStatus)((Object)input.read(PreloadingStatus.class));
                    continue block14;
                }
                case "prerenderStatus": {
                    prerenderStatus = Optional.ofNullable((PrerenderFinalStatus)((Object)input.read(PrerenderFinalStatus.class)));
                    continue block14;
                }
                case "disallowedMojoInterface": {
                    disallowedMojoInterface = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "mismatchedHeaders": {
                    mismatchedHeaders = Optional.ofNullable(input.readArray(PrerenderMismatchedHeaders.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderStatusUpdated(key, status, prerenderStatus, disallowedMojoInterface, mismatchedHeaders);
    }
}

