/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v129.dom.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ScrollOrientation {
    HORIZONTAL("horizontal"),
    VERTICAL("vertical");

    private String value;

    private ScrollOrientation(String value) {
        this.value = value;
    }

    public static ScrollOrientation fromString(String s) {
        return Arrays.stream(ScrollOrientation.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within ScrollOrientation "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ScrollOrientation fromJson(JsonInput input) {
        return ScrollOrientation.fromString(input.nextString());
    }
}

