/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v128.browser.model;

import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v128.browser.model.WindowState;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Bounds {
    private final Optional<Integer> left;
    private final Optional<Integer> top;
    private final Optional<Integer> width;
    private final Optional<Integer> height;
    private final Optional<WindowState> windowState;

    public Bounds(Optional<Integer> left, Optional<Integer> top, Optional<Integer> width, Optional<Integer> height, Optional<WindowState> windowState) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.windowState = windowState;
    }

    public Optional<Integer> getLeft() {
        return this.left;
    }

    public Optional<Integer> getTop() {
        return this.top;
    }

    public Optional<Integer> getWidth() {
        return this.width;
    }

    public Optional<Integer> getHeight() {
        return this.height;
    }

    public Optional<WindowState> getWindowState() {
        return this.windowState;
    }

    private static Bounds fromJson(JsonInput input) {
        Optional<Integer> left = Optional.empty();
        Optional<Integer> top = Optional.empty();
        Optional<Integer> width = Optional.empty();
        Optional<Integer> height = Optional.empty();
        Optional<WindowState> windowState = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "left": {
                    left = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
                case "top": {
                    top = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
                case "width": {
                    width = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
                case "height": {
                    height = Optional.ofNullable(input.nextNumber().intValue());
                    continue block14;
                }
                case "windowState": {
                    windowState = Optional.ofNullable((WindowState)((Object)input.read(WindowState.class)));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Bounds(left, top, width, height, windowState);
    }
}

